/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.NestedProjectedRowData;
import org.apache.paimon.flink.PaimonDataStreamScanProvider;
import org.apache.paimon.flink.Projection;
import org.apache.paimon.flink.source.ContinuousFileStoreSource;
import org.apache.paimon.flink.source.FlinkSource;
import org.apache.paimon.flink.source.FlinkTableSource;
import org.apache.paimon.flink.source.StaticFileStoreSource;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.RowType;

public class SystemTableSource
extends FlinkTableSource {
    private final boolean unbounded;
    private final int splitBatchSize;
    private final FlinkConnectorOptions.SplitAssignMode splitAssignMode;
    private final ObjectIdentifier tableIdentifier;

    public SystemTableSource(Table table, boolean unbounded, ObjectIdentifier tableIdentifier) {
        super(table);
        this.unbounded = unbounded;
        Options options = Options.fromMap(table.options());
        this.splitBatchSize = options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_BATCH_SIZE);
        this.splitAssignMode = options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_ASSIGN_MODE);
        this.tableIdentifier = tableIdentifier;
    }

    public SystemTableSource(Table table, boolean unbounded, @Nullable Predicate predicate, @Nullable int[][] projectFields, @Nullable Long limit, int splitBatchSize, FlinkConnectorOptions.SplitAssignMode splitAssignMode, ObjectIdentifier tableIdentifier) {
        super(table, predicate, projectFields, limit);
        this.unbounded = unbounded;
        this.splitBatchSize = splitBatchSize;
        this.splitAssignMode = splitAssignMode;
        this.tableIdentifier = tableIdentifier;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        NestedProjectedRowData rowData = null;
        RowType readType = null;
        if (this.projectFields != null) {
            Projection projection = Projection.of(this.projectFields);
            rowData = projection.getOuterProjectRow(this.table.rowType());
            readType = projection.project(this.table.rowType());
        }
        ReadBuilder readBuilder = this.table.newReadBuilder();
        if (readType != null) {
            readBuilder.withReadType(readType);
        }
        readBuilder.withFilter(this.getPredicateWithScanPartitions());
        FlinkSource source2 = this.unbounded && this.table instanceof DataTable ? new ContinuousFileStoreSource(readBuilder, this.table.options(), this.limit, false, rowData) : new StaticFileStoreSource(readBuilder, this.limit, this.splitBatchSize, this.splitAssignMode, null, rowData);
        return new PaimonDataStreamScanProvider(source2.getBoundedness() == Boundedness.BOUNDED, env -> {
            Integer parallelism = this.inferSourceParallelism((StreamExecutionEnvironment)env);
            DataStreamSource dataStreamSource = env.fromSource(source2, WatermarkStrategy.noWatermarks(), this.tableIdentifier.asSummaryString());
            if (parallelism != null) {
                dataStreamSource.setParallelism(parallelism.intValue());
            }
            return dataStreamSource;
        });
    }

    public SystemTableSource copy() {
        return new SystemTableSource(this.table, this.unbounded, this.predicate, this.projectFields, this.limit, this.splitBatchSize, this.splitAssignMode, this.tableIdentifier);
    }

    public String asSummaryString() {
        return "Paimon-SystemTable-Source";
    }

    @Override
    public boolean isUnbounded() {
        return this.unbounded;
    }
}

