/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.network;

import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.paimon.shade.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.paimon.shade.netty4.io.netty.buffer.PooledByteBufAllocator;
import org.apache.paimon.utils.Preconditions;

public class NettyBufferPool
implements ByteBufAllocator {
    private final PooledByteBufAllocator alloc;

    public NettyBufferPool(int numberOfArenas) {
        Preconditions.checkArgument(numberOfArenas >= 1, "Number of arenas");
        boolean preferDirect = true;
        int pageSize = 8192;
        int maxOrder = 11;
        int numDirectArenas = numberOfArenas;
        int numHeapArenas = 0;
        this.alloc = new PooledByteBufAllocator(preferDirect, numHeapArenas, numDirectArenas, pageSize, maxOrder);
    }

    @Override
    public ByteBuf buffer() {
        return this.alloc.buffer();
    }

    @Override
    public ByteBuf buffer(int initialCapacity) {
        return this.alloc.buffer(initialCapacity);
    }

    @Override
    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.alloc.buffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf ioBuffer() {
        return this.alloc.ioBuffer();
    }

    @Override
    public ByteBuf ioBuffer(int initialCapacity) {
        return this.alloc.ioBuffer(initialCapacity);
    }

    @Override
    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.ioBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf heapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    @Override
    public ByteBuf directBuffer() {
        return this.alloc.directBuffer();
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity) {
        return this.alloc.directBuffer(initialCapacity);
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        return this.alloc.compositeBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.alloc.compositeBuffer(maxNumComponents);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.alloc.compositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.alloc.compositeDirectBuffer(maxNumComponents);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.alloc.isDirectBufferPooled();
    }

    @Override
    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return this.alloc.calculateNewCapacity(minNewCapacity, maxCapacity);
    }
}

