/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.utils.RecyclableIterator;
import org.apache.paimon.utils.VectorMappingUtils;

public class ColumnarRowIterator
extends RecyclableIterator<InternalRow> {
    private final ColumnarRow rowData;
    private final Runnable recycler;
    private int num;
    private int pos;

    public ColumnarRowIterator(ColumnarRow rowData, @Nullable Runnable recycler) {
        super(recycler);
        this.rowData = rowData;
        this.recycler = recycler;
    }

    public void set(int num) {
        this.num = num;
        this.pos = 0;
    }

    @Override
    @Nullable
    public InternalRow next() {
        if (this.pos < this.num) {
            this.rowData.setRowId(this.pos++);
            return this.rowData;
        }
        return null;
    }

    public ColumnarRowIterator mapping(@Nullable PartitionInfo partitionInfo, @Nullable int[] indexMapping) {
        if (partitionInfo != null || indexMapping != null) {
            VectorizedColumnBatch vectorizedColumnBatch = this.rowData.vectorizedColumnBatch();
            ColumnVector[] vectors = vectorizedColumnBatch.columns;
            if (partitionInfo != null) {
                vectors = VectorMappingUtils.createPartitionMappedVectors(partitionInfo, vectors);
            }
            if (indexMapping != null) {
                vectors = VectorMappingUtils.createIndexMappedVectors(indexMapping, vectors);
            }
            ColumnarRowIterator iterator = new ColumnarRowIterator(this.rowData.copy(vectors), this.recycler);
            iterator.set(this.num);
            return iterator;
        }
        return this;
    }
}

