/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.NestedRow;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class InternalRowSerializer
extends AbstractRowDataSerializer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final BinaryRowSerializer binarySerializer;
    private final DataType[] types;
    private final Serializer[] fieldSerializers;
    private final InternalRow.FieldGetter[] fieldGetters;
    private transient BinaryRow reuseRow;
    private transient BinaryRowWriter reuseWriter;

    public InternalRowSerializer(RowType rowType) {
        this(rowType.getFieldTypes().toArray(new DataType[0]), (Serializer[])rowType.getFieldTypes().stream().map(InternalSerializers::create).toArray(Serializer[]::new));
    }

    public InternalRowSerializer(DataType ... types) {
        this(types, (Serializer[])Arrays.stream(types).map(InternalSerializers::create).toArray(Serializer[]::new));
    }

    public InternalRowSerializer(DataType[] types, Serializer<?>[] fieldSerializers) {
        this.types = types;
        this.fieldSerializers = fieldSerializers;
        this.binarySerializer = new BinaryRowSerializer(types.length);
        this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, types.length).mapToObj(i -> InternalRow.createFieldGetter(types[i], i)).toArray(InternalRow.FieldGetter[]::new);
    }

    public InternalRowSerializer duplicate() {
        Serializer[] duplicateFieldSerializers = new Serializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new InternalRowSerializer(this.types, duplicateFieldSerializers);
    }

    @Override
    public void serialize(InternalRow row, DataOutputView target) throws IOException {
        this.binarySerializer.serialize(this.toBinaryRow(row), target);
    }

    @Override
    public InternalRow deserialize(DataInputView source) throws IOException {
        return this.binarySerializer.deserialize(source);
    }

    @Override
    public InternalRow copy(InternalRow from) {
        if (from.getFieldCount() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getFieldCount() + ", but serializer arity: " + this.types.length);
        }
        if (from instanceof BinaryRow) {
            return ((BinaryRow)from).copy();
        }
        if (from instanceof NestedRow) {
            return ((NestedRow)from).copy();
        }
        return this.copyRowData(from, new GenericRow(from.getFieldCount()));
    }

    public InternalRow copyRowData(InternalRow from, InternalRow reuse) {
        GenericRow ret = reuse instanceof GenericRow ? (GenericRow)reuse : new GenericRow(from.getFieldCount());
        ret.setRowKind(from.getRowKind());
        for (int i = 0; i < from.getFieldCount(); ++i) {
            if (!from.isNullAt(i)) {
                ret.setField(i, this.fieldSerializers[i].copy(this.fieldGetters[i].getFieldOrNull(from)));
                continue;
            }
            ret.setField(i, null);
        }
        return ret;
    }

    @Override
    public int getArity() {
        return this.types.length;
    }

    public DataType[] fieldTypes() {
        return this.types;
    }

    @Override
    public BinaryRow toBinaryRow(InternalRow row) {
        if (row instanceof BinaryRow) {
            return (BinaryRow)row;
        }
        if (this.reuseRow == null) {
            this.reuseRow = new BinaryRow(this.types.length);
            this.reuseWriter = new BinaryRowWriter(this.reuseRow);
        }
        this.reuseWriter.reset();
        this.reuseWriter.writeRowKind(row.getRowKind());
        for (int i = 0; i < this.types.length; ++i) {
            if (row.isNullAt(i)) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, this.fieldGetters[i].getFieldOrNull(row), this.types[i], this.fieldSerializers[i]);
        }
        this.reuseWriter.complete();
        return this.reuseRow;
    }

    @Override
    public int serializeToPages(InternalRow row, AbstractPagedOutputView target) throws IOException {
        return this.binarySerializer.serializeToPages(this.toBinaryRow(row), target);
    }

    @Override
    public InternalRow deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public InternalRow deserializeFromPages(InternalRow reuse, AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public InternalRow mapFromPages(InternalRow reuse, AbstractPagedInputView source) throws IOException {
        if (reuse instanceof BinaryRow) {
            return this.binarySerializer.mapFromPages((BinaryRow)reuse, source);
        }
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public void skipRecordFromPages(AbstractPagedInputView source) throws IOException {
        this.binarySerializer.skipRecordFromPages(source);
    }

    public boolean equals(Object obj) {
        if (obj instanceof InternalRowSerializer) {
            InternalRowSerializer other = (InternalRowSerializer)obj;
            return Arrays.equals(this.fieldSerializers, other.fieldSerializers);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldSerializers);
    }
}

