/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.MultiTablesSinkMode;
import org.apache.paimon.flink.compact.UnawareBucketCompactionTopoBuilder;
import org.apache.paimon.flink.sink.BucketsRowChannelComputer;
import org.apache.paimon.flink.sink.CompactorSinkBuilder;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.flink.sink.MultiTablesCompactorSink;
import org.apache.paimon.flink.source.CompactorSourceBuilder;
import org.apache.paimon.flink.source.MultiTablesCompactorSourceBuilder;
import org.apache.paimon.flink.utils.StreamExecutionEnvironmentUtils;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactDatabaseAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(CompactDatabaseAction.class);
    private Pattern includingPattern = Pattern.compile(".*");
    @Nullable
    private Pattern excludingPattern;
    private Pattern databasePattern = Pattern.compile(".*");
    private MultiTablesSinkMode databaseCompactMode = MultiTablesSinkMode.DIVIDED;
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private Options tableOptions = new Options();

    public CompactDatabaseAction(String warehouse, Map<String, String> catalogConfig) {
        super(warehouse, catalogConfig);
    }

    public CompactDatabaseAction includingDatabases(@Nullable String includingDatabases) {
        if (includingDatabases != null) {
            this.databasePattern = Pattern.compile(includingDatabases);
        }
        return this;
    }

    public CompactDatabaseAction includingTables(@Nullable String includingTables) {
        if (includingTables != null) {
            this.includingPattern = Pattern.compile(includingTables);
        }
        return this;
    }

    public CompactDatabaseAction excludingTables(@Nullable String excludingTables) {
        this.excludingPattern = excludingTables == null ? null : Pattern.compile(excludingTables);
        return this;
    }

    public CompactDatabaseAction withDatabaseCompactMode(@Nullable String mode) {
        this.databaseCompactMode = MultiTablesSinkMode.fromString(mode);
        return this;
    }

    public CompactDatabaseAction withTableOptions(Map<String, String> tableOptions) {
        this.tableOptions = Options.fromMap(tableOptions);
        return this;
    }

    private boolean shouldCompactionTable(String paimonFullTableName) {
        boolean shouldCompaction = this.includingPattern.matcher(paimonFullTableName).matches();
        if (this.excludingPattern != null) {
            boolean bl = shouldCompaction = shouldCompaction && !this.excludingPattern.matcher(paimonFullTableName).matches();
        }
        if (!shouldCompaction) {
            LOG.debug("Source table '{}' is excluded.", (Object)paimonFullTableName);
        }
        return shouldCompaction;
    }

    @Override
    public void build() {
        if (this.databaseCompactMode == MultiTablesSinkMode.DIVIDED) {
            this.buildForDividedMode();
        } else {
            this.buildForCombinedMode();
        }
    }

    private void buildForDividedMode() {
        try {
            List<String> databases = this.catalog.listDatabases();
            for (String databaseName : databases) {
                Matcher databaseMatcher = this.databasePattern.matcher(databaseName);
                if (!databaseMatcher.matches()) continue;
                List<String> tables = this.catalog.listTables(databaseName);
                for (String tableName : tables) {
                    String fullTableName = String.format("%s.%s", databaseName, tableName);
                    if (this.shouldCompactionTable(fullTableName)) {
                        Table table = this.catalog.getTable(Identifier.create(databaseName, tableName));
                        if (!(table instanceof FileStoreTable)) {
                            LOG.error(String.format("Only FileStoreTable supports compact action. The table type is '%s'.", table.getClass().getName()));
                            continue;
                        }
                        table = table.copy(Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "false"));
                        this.tableMap.put(fullTableName, table);
                        continue;
                    }
                    LOG.debug("The table {} is excluded.", (Object)fullTableName);
                }
            }
        }
        catch (Catalog.DatabaseNotExistException | Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
        Preconditions.checkState(!this.tableMap.isEmpty(), "no tables to be compacted. possible cause is that there are no tables detected after pattern matching");
        ReadableConfig conf = StreamExecutionEnvironmentUtils.getConfiguration(this.env);
        boolean isStreaming = conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        block7: for (Map.Entry<String, Table> entry : this.tableMap.entrySet()) {
            FileStoreTable fileStoreTable = (FileStoreTable)entry.getValue();
            switch (fileStoreTable.bucketMode()) {
                case UNAWARE: {
                    this.buildForUnawareBucketCompaction(this.env, entry.getKey(), (AppendOnlyFileStoreTable)entry.getValue(), isStreaming);
                    continue block7;
                }
            }
            this.buildForTraditionalCompaction(this.env, entry.getKey(), fileStoreTable, isStreaming);
        }
    }

    private void buildForCombinedMode() {
        ReadableConfig conf = StreamExecutionEnvironmentUtils.getConfiguration(this.env);
        boolean isStreaming = conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        MultiTablesCompactorSourceBuilder sourceBuilder = new MultiTablesCompactorSourceBuilder(this.catalogLoader(), this.databasePattern, this.includingPattern, this.excludingPattern, this.tableOptions.get(CoreOptions.CONTINUOUS_DISCOVERY_INTERVAL).toMillis());
        DataStream<RowData> source = sourceBuilder.withEnv(this.env).withContinuousMode(isStreaming).build();
        DataStream<RowData> partitioned = FlinkStreamPartitioner.partition(source, new BucketsRowChannelComputer(), this.tableOptions.get(FlinkConnectorOptions.SINK_PARALLELISM));
        new MultiTablesCompactorSink(this.catalogLoader(), this.tableOptions).sinkFrom(partitioned);
    }

    private void buildForTraditionalCompaction(StreamExecutionEnvironment env, String fullName, FileStoreTable table, boolean isStreaming) {
        CompactorSourceBuilder sourceBuilder = new CompactorSourceBuilder(fullName, table);
        CompactorSinkBuilder sinkBuilder = new CompactorSinkBuilder(table);
        DataStreamSource<RowData> source = sourceBuilder.withEnv(env).withContinuousMode(isStreaming).build();
        sinkBuilder.withInput((DataStream<RowData>)source).build();
    }

    private void buildForUnawareBucketCompaction(StreamExecutionEnvironment env, String fullName, AppendOnlyFileStoreTable table, boolean isStreaming) {
        UnawareBucketCompactionTopoBuilder unawareBucketCompactionTopoBuilder = new UnawareBucketCompactionTopoBuilder(env, fullName, table);
        unawareBucketCompactionTopoBuilder.withContinuousMode(isStreaming);
        unawareBucketCompactionTopoBuilder.build();
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.execute("Compact database job");
    }
}

