/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.FileStoreTable;

public class DropPartitionAction
extends TableActionBase {
    private final List<Map<String, String>> partitions;
    private final FileStoreCommit commit;

    public DropPartitionAction(String warehouse, String databaseName, String tableName, List<Map<String, String>> partitions, Map<String, String> catalogConfig) {
        super(warehouse, databaseName, tableName, catalogConfig);
        if (!(this.table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only FileStoreTable supports drop-partition action. The table type is '%s'.", this.table.getClass().getName()));
        }
        this.partitions = partitions;
        AbstractFileStoreTable fileStoreTable = (AbstractFileStoreTable)this.table;
        this.commit = fileStoreTable.store().newCommit(UUID.randomUUID().toString());
    }

    @Override
    public void run() throws Exception {
        this.commit.dropPartitions(this.partitions, Long.MAX_VALUE);
    }
}

