/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.sink.FlinkSinkBuilder;
import org.apache.paimon.flink.utils.TableEnvironmentUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;

public abstract class TableActionBase
extends ActionBase {
    protected Table table;
    protected final Identifier identifier;

    TableActionBase(String warehouse, String databaseName, String tableName, Map<String, String> catalogConfig) {
        super(warehouse, catalogConfig);
        this.identifier = new Identifier(databaseName, tableName);
        try {
            this.table = this.catalog.getTable(this.identifier);
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    public TableResult batchSink(DataStream<RowData> dataStream) {
        List<Transformation<?>> transformations = Collections.singletonList(new FlinkSinkBuilder((FileStoreTable)this.table).withInput(dataStream).build().getTransformation());
        List<String> sinkIdentifierNames = Collections.singletonList(this.identifier.getFullName());
        return TableEnvironmentUtils.executeInternal(this.batchTEnv, transformations, sinkIdentifierNames);
    }

    protected void changeIgnoreMergeEngine() {
        if (CoreOptions.fromMap(this.table.options()).mergeEngine() != CoreOptions.MergeEngine.DEDUPLICATE) {
            HashMap<String, String> dynamicOptions = new HashMap<String, String>();
            dynamicOptions.put(CoreOptions.MERGE_ENGINE.key(), CoreOptions.MergeEngine.DEDUPLICATE.toString());
            dynamicOptions.put(CoreOptions.FULL_COMPACTION_DELTA_COMMITS.key(), "1");
            Preconditions.checkArgument(this.table instanceof FileStoreTable, "Only supports FileStoreTable.");
            this.table = ((FileStoreTable)this.table).internalCopyWithoutCheck(dynamicOptions);
        }
    }
}

