/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.Expression;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

public class ComputedColumnUtils {
    public static List<ComputedColumn> buildComputedColumns(List<String> computedColumnArgs, List<DataField> physicFields) {
        Map<String, DataType> typeMapping = physicFields.stream().collect(Collectors.toMap(DataField::name, DataField::type, (v1, v2) -> v2));
        ArrayList<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
        for (String columnArg : computedColumnArgs) {
            String[] kv = columnArg.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid computed column argument: %s. Please use format 'column-name=expr-name(args, ...)'.", columnArg));
            }
            String columnName = kv[0].trim();
            String expression = kv[1].trim();
            int left = expression.indexOf(40);
            int right = expression.indexOf(41);
            Preconditions.checkArgument(left > 0 && right > left, String.format("Invalid expression: %s. Please use format 'expr-name(args, ...)'.", expression));
            String exprName = expression.substring(0, left);
            String[] args = expression.substring(left + 1, right).split(",");
            Preconditions.checkArgument(args.length >= 1, "Computed column needs at least one argument.");
            String fieldReference = args[0].trim();
            String[] literals = (String[])Arrays.stream(args).skip(1L).map(String::trim).toArray(String[]::new);
            Preconditions.checkArgument(typeMapping.containsKey(fieldReference), String.format("Referenced field '%s' is not in given fields: %s.", fieldReference, typeMapping.keySet()));
            computedColumns.add(new ComputedColumn(columnName, Expression.create(exprName, fieldReference, typeMapping.get(fieldReference), literals)));
        }
        return computedColumns;
    }
}

