/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Preconditions;

public interface Expression
extends Serializable {
    public static final List<String> SUPPORTED_EXPRESSION = Arrays.asList("year", "month", "day", "hour", "date_format", "substring", "truncate");

    public String fieldReference();

    public DataType outputType();

    public String eval(String var1);

    public static Expression create(String exprName, String fieldReference, DataType fieldType, String ... literals) {
        switch (exprName.toLowerCase()) {
            case "year": {
                return Expression.year(fieldReference);
            }
            case "month": {
                return Expression.month(fieldReference);
            }
            case "day": {
                return Expression.day(fieldReference);
            }
            case "hour": {
                return Expression.hour(fieldReference);
            }
            case "date_format": {
                return Expression.dateFormat(fieldReference, literals);
            }
            case "substring": {
                return Expression.substring(fieldReference, literals);
            }
            case "truncate": {
                return Expression.truncate(fieldReference, fieldType, literals);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported expression: %s. Supported expressions are: %s", exprName, String.join((CharSequence)",", SUPPORTED_EXPRESSION)));
    }

    public static Expression year(String fieldReference) {
        return new YearComputer(fieldReference);
    }

    public static Expression month(String fieldReference) {
        return new MonthComputer(fieldReference);
    }

    public static Expression day(String fieldReference) {
        return new DayComputer(fieldReference);
    }

    public static Expression hour(String fieldReference) {
        return new HourComputer(fieldReference);
    }

    public static Expression dateFormat(String fieldReference, String ... literals) {
        Preconditions.checkArgument(literals.length == 1, String.format("'date_format' expression supports one argument, but found '%s'.", literals.length));
        return new DateFormat(fieldReference, literals[0]);
    }

    public static Expression substring(String fieldReference, String ... literals) {
        Integer endExclusive;
        int beginInclusive;
        Preconditions.checkArgument(literals.length == 1 || literals.length == 2, String.format("'substring' expression supports one or two arguments, but found '%s'.", literals.length));
        try {
            beginInclusive = Integer.parseInt(literals[0]);
            endExclusive = literals.length == 1 ? null : Integer.valueOf(Integer.parseInt(literals[1]));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("The index arguments '%s' contain non integer value.", Arrays.toString(literals)), e);
        }
        Preconditions.checkArgument(beginInclusive >= 0, "begin index argument (%s) of 'substring' must be >= 0.", beginInclusive);
        Preconditions.checkArgument(endExclusive == null || endExclusive > beginInclusive, "end index (%s) must be larger than begin index (%s).", endExclusive, beginInclusive);
        return new Substring(fieldReference, beginInclusive, endExclusive);
    }

    public static Expression truncate(String fieldReference, DataType fieldType, String ... literals) {
        Preconditions.checkArgument(literals.length == 1, String.format("'truncate' expression supports one argument, but found '%s'.", literals.length));
        return new TruncateComputer(fieldReference, fieldType, literals[0]);
    }

    public static final class TruncateComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final DataType fieldType;
        private final int width;

        TruncateComputer(String fieldReference, DataType fieldType, String literal) {
            this.fieldReference = fieldReference;
            this.fieldType = fieldType;
            try {
                this.width = Integer.parseInt(literal);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid width value for truncate function: %s, expected integer.", literal));
            }
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return this.fieldType;
        }

        @Override
        public String eval(String input) {
            switch (this.fieldType.getTypeRoot()) {
                case TINYINT: 
                case SMALLINT: {
                    return String.valueOf(this.truncateShort(this.width, Short.parseShort(input)));
                }
                case INTEGER: {
                    return String.valueOf(this.truncateInt(this.width, Integer.parseInt(input)));
                }
                case BIGINT: {
                    return String.valueOf(this.truncateLong(this.width, Long.parseLong(input)));
                }
                case DECIMAL: {
                    return this.truncateDecimal(BigInteger.valueOf(this.width), new BigDecimal(input)).toString();
                }
                case VARCHAR: 
                case CHAR: {
                    Preconditions.checkArgument(this.width <= input.length(), "Invalid width value for truncate function: %s, expected less than or equal to %s.", this.width, input.length());
                    return input.substring(0, this.width);
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported field type for truncate function: %s.", this.fieldType.getTypeRoot().toString()));
        }

        private short truncateShort(int width, short value) {
            return (short)(value - (value % width + width) % width);
        }

        private int truncateInt(int width, int value) {
            return value - (value % width + width) % width;
        }

        private long truncateLong(int width, long value) {
            return value - (value % (long)width + (long)width) % (long)width;
        }

        private BigDecimal truncateDecimal(BigInteger unscaledWidth, BigDecimal value) {
            BigDecimal remainder = new BigDecimal(value.unscaledValue().remainder(unscaledWidth).add(unscaledWidth).remainder(unscaledWidth), value.scale());
            return value.subtract(remainder);
        }
    }

    public static final class Substring
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final int beginInclusive;
        @Nullable
        private final Integer endExclusive;

        private Substring(String fieldReference, int beginInclusive, @Nullable Integer endExclusive) {
            this.fieldReference = fieldReference;
            this.beginInclusive = beginInclusive;
            this.endExclusive = endExclusive;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        public String eval(String input) {
            try {
                if (this.endExclusive == null) {
                    return input.substring(this.beginInclusive);
                }
                return input.substring(this.beginInclusive, this.endExclusive);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new RuntimeException(String.format("Cannot get substring from '%s' because the indexes are out of range. Begin index: %s, end index: %s.", input, this.beginInclusive, this.endExclusive));
            }
        }
    }

    public static final class DateFormat
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final String pattern;
        private transient DateTimeFormatter formatter;

        private DateFormat(String fieldReference, String pattern) {
            this.fieldReference = fieldReference;
            this.pattern = pattern;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        public String eval(String input) {
            if (this.formatter == null) {
                this.formatter = DateTimeFormatter.ofPattern(this.pattern);
            }
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(input, 0);
            return localDateTime.format(this.formatter);
        }
    }

    public static final class HourComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;

        private HourComputer(String fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(input, 0);
            return String.valueOf(localDateTime.getHour());
        }
    }

    public static final class DayComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;

        private DayComputer(String fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(input, 0);
            return String.valueOf(localDateTime.getDayOfMonth());
        }
    }

    public static final class MonthComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;

        private MonthComputer(String fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(input, 0);
            return String.valueOf(localDateTime.getMonthValue());
        }
    }

    public static final class YearComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;

        private YearComputer(String fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(input, 0);
            return String.valueOf(localDateTime.getYear());
        }
    }
}

