/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.canal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.RecordParser;
import org.apache.paimon.flink.action.cdc.format.canal.CanalFieldParser;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalRecordParser
extends RecordParser {
    private static final Logger LOG = LoggerFactory.getLogger(CanalRecordParser.class);
    private static final String FIELD_IS_DDL = "isDdl";
    private static final String FIELD_MYSQL_TYPE = "mysqlType";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_OLD = "old";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_DELETE = "DELETE";
    private static final String OP_ROW = "ROW";

    @Override
    protected boolean isDDL() {
        JsonNode node = this.root.get(FIELD_IS_DDL);
        return !JsonSerdeUtil.isNull(node) && node.asBoolean();
    }

    public CanalRecordParser(boolean caseSensitive, TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        super(caseSensitive, typeMapping, computedColumns);
    }

    @Override
    public List<RichCdcMultiplexRecord> extractRecords() {
        if (this.isDDL()) {
            return Collections.emptyList();
        }
        ArrayList<RichCdcMultiplexRecord> records = new ArrayList<RichCdcMultiplexRecord>();
        ArrayNode arrayData = JsonSerdeUtil.getNodeAs(this.root, this.dataField(), ArrayNode.class);
        this.checkNotNull(arrayData, this.dataField());
        String type = this.getAndCheck(FIELD_TYPE).asText();
        block11: for (JsonNode data : arrayData) {
            switch (type) {
                case "UPDATE": {
                    ArrayNode oldArrayData = JsonSerdeUtil.getNodeAs(this.root, FIELD_OLD, ArrayNode.class);
                    this.checkNotNull(oldArrayData, FIELD_OLD, FIELD_TYPE, type);
                    Map<JsonNode, JsonNode> matchedOldRecords = this.matchOldRecords(arrayData, oldArrayData);
                    JsonNode old = matchedOldRecords.get(data);
                    this.processRecord(this.mergeOldRecord(data, old), RowKind.DELETE, records);
                    this.processRecord(data, RowKind.INSERT, records);
                    continue block11;
                }
                case "INSERT": 
                case "ROW": {
                    this.processRecord(data, RowKind.INSERT, records);
                    continue block11;
                }
                case "DELETE": {
                    this.processRecord(data, RowKind.DELETE, records);
                    continue block11;
                }
            }
            throw new UnsupportedOperationException("Unknown record operation: " + type);
        }
        return records;
    }

    @Override
    protected LinkedHashMap<String, DataType> extractPaimonFieldTypes() {
        LinkedHashMap<String, String> originalFieldTypes = this.tryExtractOriginalFieldTypes();
        if (originalFieldTypes != null) {
            return this.toPaimonFieldTypes(originalFieldTypes);
        }
        ArrayNode records = JsonSerdeUtil.getNodeAs(this.root, this.dataField(), ArrayNode.class);
        this.checkNotNull(records, this.dataField());
        JsonNode record = records.get(0);
        return this.fillDefaultStringTypes(record);
    }

    @Nullable
    private LinkedHashMap<String, String> tryExtractOriginalFieldTypes() {
        JsonNode schema = this.root.get(FIELD_MYSQL_TYPE);
        if (JsonSerdeUtil.isNull(schema)) {
            LOG.debug("Cannot get original field types because '{}' field is missing.", (Object)FIELD_MYSQL_TYPE);
            return null;
        }
        return OBJECT_MAPPER.convertValue((Object)schema, new TypeReference<LinkedHashMap<String, String>>(){});
    }

    private LinkedHashMap<String, DataType> toPaimonFieldTypes(LinkedHashMap<String, String> originalFieldTypes) {
        LinkedHashMap<String, DataType> paimonFieldTypes = new LinkedHashMap<String, DataType>();
        originalFieldTypes.forEach((name, type) -> paimonFieldTypes.put((String)name, MySqlTypeUtils.toDataType(type, this.typeMapping)));
        return paimonFieldTypes;
    }

    @Override
    protected String primaryField() {
        return "pkNames";
    }

    @Override
    protected String dataField() {
        return "data";
    }

    @Override
    protected Map<String, String> extractRowData(JsonNode record, LinkedHashMap<String, DataType> paimonFieldTypes) {
        LinkedHashMap<String, String> originalFieldTypes = this.tryExtractOriginalFieldTypes();
        Map<String, Object> recordMap = OBJECT_MAPPER.convertValue((Object)record, new TypeReference<Map<String, Object>>(){});
        HashMap<String, String> rowData = new HashMap<String, String>();
        if (originalFieldTypes != null) {
            paimonFieldTypes.putAll(this.toPaimonFieldTypes(originalFieldTypes));
            for (Map.Entry<String, Object> entry : recordMap.entrySet()) {
                String fieldName = entry.getKey();
                String originalType = originalFieldTypes.get(fieldName);
                String newValue = this.transformValue(Objects.toString(entry.getValue(), null), originalType);
                rowData.put(fieldName, newValue);
            }
        } else {
            paimonFieldTypes.putAll(this.fillDefaultStringTypes(record));
            for (Map.Entry<String, Object> entry : recordMap.entrySet()) {
                rowData.put(entry.getKey(), Objects.toString(entry.getValue(), null));
            }
        }
        this.evalComputedColumns(rowData, paimonFieldTypes);
        return rowData;
    }

    @Override
    protected String format() {
        return "canal-json";
    }

    private Map<JsonNode, JsonNode> matchOldRecords(ArrayNode newData, ArrayNode oldData) {
        return IntStream.range(0, newData.size()).boxed().collect(Collectors.toMap(newData::get, oldData::get));
    }

    private String transformValue(@Nullable String oldValue, String mySqlType) {
        if (oldValue == null) {
            return null;
        }
        String shortType = MySqlTypeUtils.getShortType(mySqlType);
        if (MySqlTypeUtils.isSetType(shortType)) {
            return CanalFieldParser.convertSet(oldValue, mySqlType);
        }
        if (MySqlTypeUtils.isEnumType(shortType)) {
            return CanalFieldParser.convertEnum(oldValue, mySqlType);
        }
        if (MySqlTypeUtils.isGeoType(shortType)) {
            try {
                byte[] wkb = CanalFieldParser.convertGeoType2WkbArray(oldValue.getBytes(StandardCharsets.ISO_8859_1));
                return MySqlTypeUtils.convertWkbArray(wkb);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", oldValue), e);
            }
        }
        return oldValue;
    }
}

