/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka;

import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.paimon.flink.action.cdc.MessageQueueSchemaUtils;
import org.apache.paimon.flink.action.cdc.MessageQueueSyncTableActionBase;
import org.apache.paimon.flink.action.cdc.format.DataFormat;
import org.apache.paimon.flink.action.cdc.kafka.KafkaActionUtils;

public class KafkaSyncTableAction
extends MessageQueueSyncTableActionBase {
    public KafkaSyncTableAction(String warehouse, String database, String table, Map<String, String> catalogConfig, Map<String, String> kafkaConfig) {
        super(warehouse, database, table, catalogConfig, kafkaConfig);
    }

    @Override
    protected DataStreamSource<String> buildSource() {
        return this.buildDataStreamSource(KafkaActionUtils.buildKafkaSource(this.cdcSourceConfig));
    }

    @Override
    protected String topic() {
        return (String)((List)this.cdcSourceConfig.get(KafkaConnectorOptions.TOPIC)).get(0);
    }

    @Override
    protected MessageQueueSchemaUtils.ConsumerWrapper consumer(String topic) {
        return KafkaActionUtils.getKafkaEarliestConsumer(this.cdcSourceConfig, topic);
    }

    @Override
    protected DataFormat getDataFormat() {
        return KafkaActionUtils.getDataFormat(this.cdcSourceConfig);
    }

    @Override
    protected String sourceName() {
        return "Kafka Source";
    }

    @Override
    protected String jobName() {
        return String.format("Kafka-Paimon Table Sync: %s.%s", this.database, this.table);
    }
}

