/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSource;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSourceBuilder;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.JsonDebeziumDeserializationSchema;
import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.utils.Preconditions;

public class MongoDBActionUtils {
    private static final String INITIAL_MODE = "initial";
    private static final String LATEST_OFFSET_MODE = "latest-offset";
    private static final String TIMESTAMP_MODE = "timestamp";
    public static final ConfigOption<String> FIELD_NAME = ConfigOptions.key((String)"field.name").stringType().noDefaultValue().withDescription("Field names to synchronize when in `specified` mode.");
    public static final ConfigOption<String> PARSER_PATH = ConfigOptions.key((String)"parser.path").stringType().noDefaultValue().withDescription("JSON parsing path for field synchronization in `specified` mode.");
    public static final ConfigOption<String> START_MODE = ConfigOptions.key((String)"schema.start.mode").stringType().defaultValue((Object)"dynamic").withDescription("Mode selection: `dynamic` or `specified`.");
    public static final ConfigOption<Boolean> DEFAULT_ID_GENERATION = ConfigOptions.key((String)"default.id.generation").booleanType().defaultValue((Object)true).withDescription("Determines whether to use the default MongoDB _id generation strategy. If set to true, the default _id generation will remove the outer $oid nesting. If set to false, no additional processing will be done on the _id field.");

    public static MongoDBSource<String> buildMongodbSource(Configuration mongodbConfig, String tableList) {
        MongoDBActionUtils.validateMongodbConfig(mongodbConfig);
        MongoDBSourceBuilder sourceBuilder = MongoDBSource.builder();
        if (mongodbConfig.contains(MongoDBSourceOptions.USERNAME) && mongodbConfig.contains(MongoDBSourceOptions.PASSWORD)) {
            sourceBuilder.username((String)mongodbConfig.get(MongoDBSourceOptions.USERNAME)).password((String)mongodbConfig.get(MongoDBSourceOptions.PASSWORD));
        }
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.CONNECTION_OPTIONS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).connectionOptions(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.BATCH_SIZE)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).batchSize(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).heartbeatIntervalMillis(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.SCHEME)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).scheme(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.POLL_MAX_BATCH_SIZE)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).pollMaxBatchSize(arg_0));
        Optional.ofNullable(mongodbConfig.get(MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS)).ifPresent(arg_0 -> ((MongoDBSourceBuilder)sourceBuilder).pollAwaitTimeMillis(arg_0));
        sourceBuilder.hosts((String)mongodbConfig.get(MongoDBSourceOptions.HOSTS)).databaseList(new String[]{(String)mongodbConfig.get(MongoDBSourceOptions.DATABASE)}).collectionList(new String[]{tableList});
        String startupMode = (String)mongodbConfig.get(SourceOptions.SCAN_STARTUP_MODE);
        switch (startupMode.toLowerCase()) {
            case "initial": {
                sourceBuilder.startupOptions(StartupOptions.initial());
                break;
            }
            case "latest-offset": {
                sourceBuilder.startupOptions(StartupOptions.latest());
                break;
            }
            case "timestamp": {
                sourceBuilder.startupOptions(StartupOptions.timestamp((long)((Long)mongodbConfig.get(SourceOptions.SCAN_STARTUP_TIMESTAMP_MILLIS))));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported startup mode: " + startupMode);
            }
        }
        HashMap<String, String> customConverterConfigs = new HashMap<String, String>();
        customConverterConfigs.put("decimal.format", "numeric");
        JsonDebeziumDeserializationSchema schema = new JsonDebeziumDeserializationSchema(Boolean.valueOf(false), customConverterConfigs);
        return sourceBuilder.deserializer((DebeziumDeserializationSchema)schema).build();
    }

    private static void validateMongodbConfig(Configuration mongodbConfig) {
        Preconditions.checkArgument(mongodbConfig.get(MongoDBSourceOptions.HOSTS) != null, String.format("mongodb-conf [%s] must be specified.", MongoDBSourceOptions.HOSTS.key()));
        Preconditions.checkArgument(mongodbConfig.get(MongoDBSourceOptions.DATABASE) != null, String.format("mongodb-conf [%s] must be specified.", MongoDBSourceOptions.DATABASE.key()));
    }
}

