/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.flink.action.cdc.CdcMetadataConverter;
import org.apache.paimon.flink.action.cdc.mysql.format.DebeziumEvent;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Preconditions;

public enum MySqlMetadataProcessor {
    TABLE_NAME(new CdcMetadataConverter<DebeziumEvent.Source>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String read(DebeziumEvent.Source source) {
            return source.table();
        }

        @Override
        public DataType dataType() {
            return DataTypes.STRING().notNull();
        }

        @Override
        public String columnName() {
            return "table_name";
        }
    }),
    DATABASE_NAME(new CdcMetadataConverter<DebeziumEvent.Source>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String read(DebeziumEvent.Source source) {
            return source.db();
        }

        @Override
        public DataType dataType() {
            return DataTypes.STRING().notNull();
        }

        @Override
        public String columnName() {
            return "database_name";
        }
    }),
    OP_TS(new CdcMetadataConverter<DebeziumEvent.Source>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String read(DebeziumEvent.Source source) {
            return DateTimeUtils.formatTimestamp(Timestamp.fromEpochMillis(source.tsMs()), DateTimeUtils.LOCAL_TZ, 3);
        }

        @Override
        public DataType dataType() {
            return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(3).notNull();
        }

        @Override
        public String columnName() {
            return "op_ts";
        }
    });

    private final CdcMetadataConverter<?> converter;
    private static final Map<String, CdcMetadataConverter<?>> CONVERTERS;

    private MySqlMetadataProcessor(CdcMetadataConverter<?> converter) {
        this.converter = converter;
    }

    public static CdcMetadataConverter<?> converter(String column) {
        return Preconditions.checkNotNull(CONVERTERS.get(column));
    }

    private CdcMetadataConverter<?> converter() {
        return this.converter;
    }

    static {
        CONVERTERS = Arrays.stream(MySqlMetadataProcessor.values()).collect(Collectors.toMap(value -> value.converter.columnName(), MySqlMetadataProcessor::converter));
    }
}

