/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.format;

import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.mysql.format.DebeziumEventUtils;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;

public class DebeziumEvent {
    private static final String FIELD_PAYLOAD = "payload";
    private static final String FIELD_SCHEMA = "schema";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_BEFORE = "before";
    private static final String FIELD_AFTER = "after";
    private static final String FIELD_HISTORY_RECORD = "historyRecord";
    private static final String FIELD_OP = "op";
    private static final String FIELD_DB = "db";
    private static final String FIELD_TABLE = "table";
    private static final String FIELD_TS_MS = "ts_ms";
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_FIELD = "field";
    private static final String FIELD_OPTIONAL = "optional";
    @JsonProperty(value="payload")
    private final Payload payload;
    @JsonProperty(value="schema")
    private final Field schema;

    @JsonCreator
    public DebeziumEvent(@JsonProperty(value="payload") Payload payload, @JsonProperty(value="schema") Field schema) {
        this.payload = payload;
        this.schema = schema;
    }

    @JsonGetter(value="payload")
    public Payload payload() {
        return this.payload;
    }

    @JsonGetter(value="schema")
    public Field schema() {
        return this.schema;
    }

    public static class Source {
        @JsonProperty(value="db")
        private final String db;
        @JsonProperty(value="table")
        private final String table;
        @JsonProperty(value="ts_ms")
        private final Long tsMs;

        @JsonCreator
        public Source(@JsonProperty(value="db") String db, @JsonProperty(value="table") String table, @JsonProperty(value="ts_ms") Long tsMs) {
            this.db = db;
            this.table = table;
            this.tsMs = tsMs;
        }

        @JsonGetter(value="db")
        public String db() {
            return this.db;
        }

        @JsonGetter(value="table")
        public String table() {
            return this.table;
        }

        @JsonGetter(value="ts_ms")
        public Long tsMs() {
            return this.tsMs;
        }
    }

    public static class Field {
        @JsonProperty(value="field")
        private final String field;
        @JsonProperty(value="type")
        private final String type;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="optional")
        private final Boolean optional;
        @JsonProperty(value="fields")
        private final List<Field> fields;

        @JsonCreator
        public Field(@JsonProperty(value="field") String field, @JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="optional") Boolean optional, @JsonProperty(value="fields") List<Field> fields) {
            this.field = field;
            this.type = type;
            this.name = name;
            this.optional = optional;
            this.fields = fields;
        }

        @JsonGetter(value="field")
        public String field() {
            return this.field;
        }

        @JsonGetter(value="type")
        public String type() {
            return this.type;
        }

        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        @JsonGetter(value="optional")
        public Boolean optional() {
            return this.optional;
        }

        @JsonGetter(value="fields")
        public List<Field> fields() {
            return this.fields;
        }

        public Map<String, Field> beforeAndAfterFields() {
            return this.fields.stream().filter(item -> DebeziumEvent.FIELD_BEFORE.equals(item.field) || DebeziumEvent.FIELD_AFTER.equals(item.field)).flatMap(item -> item.fields.stream()).collect(Collectors.toMap(Field::field, Function.identity(), (v1, v2) -> v2, LinkedHashMap::new));
        }
    }

    public static class Payload {
        @JsonProperty(value="source")
        private final Source source;
        @JsonProperty(value="before")
        private final JsonNode before;
        @JsonProperty(value="after")
        private final JsonNode after;
        @JsonProperty(value="historyRecord")
        private final String historyRecord;
        @JsonProperty(value="op")
        private final String op;

        @JsonCreator
        public Payload(@JsonProperty(value="source") Source source, @JsonProperty(value="before") JsonNode before, @JsonProperty(value="after") JsonNode after, @JsonProperty(value="historyRecord") String historyRecord, @JsonProperty(value="op") String op) {
            this.source = source;
            this.before = before;
            this.after = after;
            this.historyRecord = historyRecord;
            this.op = op;
        }

        @JsonGetter(value="source")
        public Source source() {
            return this.source;
        }

        @JsonGetter(value="before")
        public JsonNode before() {
            return this.before;
        }

        @JsonGetter(value="after")
        public JsonNode after() {
            return this.after;
        }

        @JsonGetter(value="historyRecord")
        public String historyRecord() {
            return this.historyRecord;
        }

        @JsonGetter(value="op")
        public String op() {
            return this.op;
        }

        public boolean isSchemaChange() {
            return this.op() == null;
        }

        public boolean hasHistoryRecord() {
            return this.historyRecord != null;
        }

        @JsonIgnore
        public Iterator<TableChanges.TableChange> getTableChanges() throws IOException {
            return DebeziumEventUtils.getTableChanges(this.historyRecord).iterator();
        }
    }
}

