/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.pulsar;

import java.util.Map;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.paimon.flink.action.cdc.MessageQueueSchemaUtils;
import org.apache.paimon.flink.action.cdc.MessageQueueSyncTableActionBase;
import org.apache.paimon.flink.action.cdc.format.DataFormat;
import org.apache.paimon.flink.action.cdc.pulsar.PulsarActionUtils;
import org.apache.pulsar.client.api.PulsarClientException;

public class PulsarSyncTableAction
extends MessageQueueSyncTableActionBase {
    public PulsarSyncTableAction(String warehouse, String database, String table, Map<String, String> catalogConfig, Map<String, String> pulsarConfig) {
        super(warehouse, database, table, catalogConfig, pulsarConfig);
    }

    @Override
    protected DataStreamSource<String> buildSource() {
        return this.buildDataStreamSource(PulsarActionUtils.buildPulsarSource(this.cdcSourceConfig));
    }

    @Override
    protected String topic() {
        return ((String)this.cdcSourceConfig.get(PulsarActionUtils.TOPIC)).split(",")[0].trim();
    }

    @Override
    protected MessageQueueSchemaUtils.ConsumerWrapper consumer(String topic) {
        try {
            return PulsarActionUtils.createPulsarConsumer(this.cdcSourceConfig, topic);
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected DataFormat getDataFormat() {
        return PulsarActionUtils.getDataFormat(this.cdcSourceConfig);
    }

    @Override
    protected String sourceName() {
        return "Pulsar Source";
    }

    @Override
    protected String jobName() {
        return String.format("Pulsar-Paimon Table Sync: %s.%s", this.database, this.table);
    }
}

