/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Map;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.MergeIntoAction;
import org.apache.paimon.flink.action.MergeIntoActionFactory;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.Preconditions;

public class MergeIntoProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "merge_into";

    public String[] call(ProcedureContext procedureContext, String targetTableId, String targetAlias, String sourceSqls, String sourceTable, String mergeCondition, String matchedUpsertCondition, String matchedUpsertSetting) {
        return this.call(procedureContext, targetTableId, targetAlias, sourceSqls, sourceTable, mergeCondition, matchedUpsertCondition, matchedUpsertSetting, "", "", "");
    }

    public String[] call(ProcedureContext procedureContext, String targetTableId, String targetAlias, String sourceSqls, String sourceTable, String mergeCondition, String matchedUpsertCondition, String matchedUpsertSetting, String notMatchedInsertCondition, String notMatchedInsertValues) {
        return this.call(procedureContext, targetTableId, targetAlias, sourceSqls, sourceTable, mergeCondition, matchedUpsertCondition, matchedUpsertSetting, notMatchedInsertCondition, notMatchedInsertValues, "");
    }

    public String[] call(ProcedureContext procedureContext, String targetTableId, String targetAlias, String sourceSqls, String sourceTable, String mergeCondition, String matchedDeleteCondition) {
        return this.call(procedureContext, targetTableId, targetAlias, sourceSqls, sourceTable, mergeCondition, "", "", "", "", matchedDeleteCondition);
    }

    public String[] call(ProcedureContext procedureContext, String targetTableId, String targetAlias, String sourceSqls, String sourceTable, String mergeCondition, String matchedUpsertCondition, String matchedUpsertSetting, String notMatchedInsertCondition, String notMatchedInsertValues, String matchedDeleteCondition) {
        String condition;
        String warehouse = ((AbstractCatalog)this.catalog).warehouse();
        Map<String, String> catalogOptions = ((AbstractCatalog)this.catalog).options();
        Identifier identifier = Identifier.fromString(targetTableId);
        MergeIntoAction action = new MergeIntoAction(warehouse, identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions);
        action.withTargetAlias(this.nullable(targetAlias));
        if (!sourceSqls.isEmpty()) {
            action.withSourceSqls(sourceSqls.split(";"));
        }
        Preconditions.checkArgument(!sourceTable.isEmpty(), "Must specify source table.");
        action.withSourceTable(sourceTable);
        Preconditions.checkArgument(!mergeCondition.isEmpty(), "Must specify merge condition.");
        action.withMergeCondition(mergeCondition);
        if (!matchedUpsertCondition.isEmpty() || !matchedUpsertSetting.isEmpty()) {
            condition = this.nullable(matchedUpsertCondition);
            String setting = this.nullable(matchedUpsertSetting);
            Preconditions.checkNotNull(setting, "matched-upsert must set the 'matchedUpsertSetting' argument");
            action.withMatchedUpsert(condition, setting);
        }
        if (!notMatchedInsertCondition.isEmpty() || !notMatchedInsertValues.isEmpty()) {
            condition = this.nullable(notMatchedInsertCondition);
            String values = this.nullable(notMatchedInsertValues);
            Preconditions.checkNotNull(values, "not-matched-insert must set the 'notMatchedInsertValues' argument");
            action.withNotMatchedInsert(condition, values);
        }
        if (!matchedDeleteCondition.isEmpty()) {
            action.withMatchedDelete(matchedDeleteCondition);
        }
        action.withStreamExecutionEnvironment(procedureContext.getExecutionEnvironment());
        MergeIntoActionFactory.validate(action);
        DataStream<RowData> dataStream = action.buildDataStream();
        TableResult tableResult = action.batchSink(dataStream);
        JobClient jobClient = (JobClient)tableResult.getJobClient().get();
        return this.execute(procedureContext, jobClient);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

