/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.paimon.annotation.VisibleForTesting;

public class CommitterMetrics {
    private static final String SINK_METRIC_GROUP = "sink";
    private final Counter numBytesOutCounter;
    private final Counter numRecordsOutCounter;

    public CommitterMetrics(OperatorIOMetricGroup metricGroup) {
        MetricGroup sinkMetricGroup = metricGroup.addGroup(SINK_METRIC_GROUP);
        this.numBytesOutCounter = metricGroup.getNumBytesOutCounter();
        sinkMetricGroup.counter("numBytesOut", this.numBytesOutCounter);
        sinkMetricGroup.meter("numBytesOutPerSecond", (Meter)new MeterView(this.numBytesOutCounter));
        this.numRecordsOutCounter = metricGroup.getNumRecordsOutCounter();
        sinkMetricGroup.counter("numRecordsOut", this.numRecordsOutCounter);
        sinkMetricGroup.meter("numRecordsOutPerSecond", (Meter)new MeterView(this.numRecordsOutCounter));
    }

    public void increaseNumBytesOut(long numBytesOut) {
        this.numBytesOutCounter.inc(numBytesOut);
    }

    public void increaseNumRecordsOut(long numRecordsOut) {
        this.numRecordsOutCounter.inc(numRecordsOut);
    }

    @VisibleForTesting
    public Counter getNumBytesOutCounter() {
        return this.numBytesOutCounter;
    }

    @VisibleForTesting
    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOutCounter;
    }
}

