/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.HashBucketAssignerOperator;
import org.apache.paimon.flink.sink.RowDynamicBucketSink;
import org.apache.paimon.table.FileStoreTable;

public class DynamicBucketCompactSink
extends RowDynamicBucketSink {
    public DynamicBucketCompactSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition) {
        super(table, overwritePartition);
    }

    @Override
    public DataStreamSink<?> build(DataStream<InternalRow> input, @Nullable Integer parallelism) {
        String initialCommitUser = UUID.randomUUID().toString();
        HashBucketAssignerOperator assignerOperator = new HashBucketAssignerOperator(initialCommitUser, this.table, this.extractorFunction(), true);
        TupleTypeInfo rowWithBucketType = new TupleTypeInfo(new TypeInformation[]{input.getType(), BasicTypeInfo.INT_TYPE_INFO});
        SingleOutputStreamOperator bucketAssigned = input.transform("dynamic-bucket-assigner", (TypeInformation)rowWithBucketType, assignerOperator).setParallelism(input.getParallelism());
        return this.sinkFrom(bucketAssigned, initialCommitUser);
    }
}

