/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.FixedBucketRowKeyExtractor;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;

public class RowDataChannelComputer
implements ChannelComputer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private final boolean hasLogSink;
    private transient int numChannels;
    private transient KeyAndBucketExtractor<InternalRow> extractor;

    public RowDataChannelComputer(TableSchema schema, boolean hasLogSink) {
        this.schema = schema;
        this.hasLogSink = hasLogSink;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new FixedBucketRowKeyExtractor(this.schema);
    }

    @Override
    public int channel(InternalRow record) {
        this.extractor.setRecord(record);
        return this.channel(this.extractor.partition(), this.extractor.bucket());
    }

    public int channel(BinaryRow partition, int bucket) {
        return this.hasLogSink ? ChannelComputer.select(bucket, this.numChannels) : ChannelComputer.select(partition, bucket, this.numChannels);
    }

    public String toString() {
        return "shuffle by bucket";
    }
}

