/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;

public class RowHashKeyChannelComputer
implements ChannelComputer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient RowPartitionKeyExtractor extractor;

    public RowHashKeyChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new RowPartitionKeyExtractor(this.schema);
    }

    @Override
    public int channel(InternalRow record) {
        int hash = this.extractor.trimmedPrimaryKey(record).hashCode();
        return Math.abs(hash % this.numChannels);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

