/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;

public class RowWithBucketChannelComputer
implements ChannelComputer<Tuple2<InternalRow, Integer>> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient RowPartitionKeyExtractor extractor;

    public RowWithBucketChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new RowPartitionKeyExtractor(this.schema);
    }

    @Override
    public int channel(Tuple2<InternalRow, Integer> record) {
        return ChannelComputer.select(this.extractor.partition((InternalRow)record.f0), (Integer)record.f1, this.numChannels);
    }

    public String toString() {
        return "shuffle by partition & bucket";
    }
}

