/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.schema.TableSchema;

public class CdcHashKeyChannelComputer
implements ChannelComputer<CdcRecord> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient CdcRecordKeyAndBucketExtractor extractor;

    public CdcHashKeyChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new CdcRecordKeyAndBucketExtractor(this.schema);
    }

    @Override
    public int channel(CdcRecord record) {
        this.extractor.setRecord(record);
        int hash = this.extractor.trimmedPrimaryKey().hashCode();
        return Math.abs(hash % this.numChannels);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

