/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.EventParser;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;

public class RichEventParser
implements EventParser<RichCdcRecord> {
    private RichCdcRecord record;
    private final LinkedHashMap<String, DataType> previousDataFields = new LinkedHashMap();

    @Override
    public void setRawEvent(RichCdcRecord rawEvent) {
        this.record = rawEvent;
    }

    @Override
    public List<DataField> parseSchemaChange() {
        ArrayList<DataField> change = new ArrayList<DataField>();
        this.record.fieldTypes().forEach((field, type) -> {
            DataType previous = this.previousDataFields.get(field);
            if (!Objects.equals(previous, type)) {
                this.previousDataFields.put((String)field, (DataType)type);
                change.add(new DataField(0, (String)field, (DataType)type));
            }
        });
        return change;
    }

    @Override
    public List<CdcRecord> parseRecords() {
        if (this.record.hasPayload()) {
            return Collections.singletonList(this.record.toCdcRecord());
        }
        return Collections.emptyList();
    }
}

