/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.io.SeekableDataInputView;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MathUtils;

public class CachedRandomInputView
extends AbstractPagedInputView
implements SeekableDataInputView,
Closeable {
    private final RandomAccessFile file;
    private final long fileLength;
    private final CacheManager cacheManager;
    private final Map<Integer, MemorySegment> segments;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private int currentSegmentIndex;

    public CachedRandomInputView(File file, CacheManager cacheManager) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, "r");
        this.fileLength = file.length();
        this.cacheManager = cacheManager;
        this.segments = new HashMap<Integer, MemorySegment>();
        int segmentSize = cacheManager.pageSize();
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.segmentSizeMask = segmentSize - 1;
        this.currentSegmentIndex = -1;
    }

    @Override
    public void setReadPosition(long position) {
        int pageNumber = (int)(position >>> this.segmentSizeBits);
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = pageNumber;
        MemorySegment segment = this.getCurrentPage();
        this.seekInput(segment, offset, this.getLimitForSegment(segment));
    }

    private MemorySegment getCurrentPage() {
        MemorySegment segment = this.segments.get(this.currentSegmentIndex);
        if (segment == null) {
            segment = this.cacheManager.getPage(this.file, this.currentSegmentIndex, this::invalidPage);
            this.segments.put(this.currentSegmentIndex, segment);
        }
        return segment;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
        ++this.currentSegmentIndex;
        if ((long)this.currentSegmentIndex << this.segmentSizeBits >= this.fileLength) {
            throw new EOFException();
        }
        return this.getCurrentPage();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return segment.size();
    }

    private void invalidPage(int pageNumber) {
        this.segments.remove(pageNumber);
    }

    @Override
    public void close() throws IOException {
        ArrayList<Integer> pages = new ArrayList<Integer>(this.segments.keySet());
        pages.forEach(page -> this.cacheManager.invalidPage(this.file, (int)page));
        this.file.close();
    }
}

