/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestFileMetaSerializer
extends VersionedObjectSerializer<ManifestFileMeta> {
    private static final long serialVersionUID = 1L;

    public ManifestFileMetaSerializer() {
        super(ManifestFileMeta.schema());
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public InternalRow convertTo(ManifestFileMeta meta) {
        return GenericRow.of(BinaryString.fromString(meta.fileName()), meta.fileSize(), meta.numAddedFiles(), meta.numDeletedFiles(), meta.partitionStats().toRowData(), meta.schemaId());
    }

    @Override
    public ManifestFileMeta convertFrom(int version, InternalRow row) {
        if (version != 2) {
            if (version == 1) {
                throw new IllegalArgumentException(String.format("The current version %s is not compatible with the version %s, please recreate the table.", this.getVersion(), version));
            }
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        return new ManifestFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), row.getLong(3), BinaryTableStats.fromRowData(row.getRow(4, 3)), row.getLong(5));
    }
}

