/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.SortBufferWriteBuffer;
import org.apache.paimon.mergetree.WriteBuffer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.operation.metrics.WriterMetrics;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.RecordWriter;

public class MergeTreeWriter
implements RecordWriter<KeyValue>,
MemoryOwner {
    private final boolean writeBufferSpillable;
    private final int sortMaxFan;
    private final IOManager ioManager;
    private final RowType keyType;
    private final RowType valueType;
    private final CompactManager compactManager;
    private final Comparator<InternalRow> keyComparator;
    private final MergeFunction<KeyValue> mergeFunction;
    private final KeyValueFileWriterFactory writerFactory;
    private final boolean commitForceCompact;
    private final CoreOptions.ChangelogProducer changelogProducer;
    private final LinkedHashSet<DataFileMeta> newFiles;
    private final LinkedHashSet<DataFileMeta> newFilesChangelog;
    private final LinkedHashMap<String, DataFileMeta> compactBefore;
    private final LinkedHashSet<DataFileMeta> compactAfter;
    private final LinkedHashSet<DataFileMeta> compactChangelog;
    private long newSequenceNumber;
    private WriteBuffer writeBuffer;
    private WriterMetrics writerMetrics;

    public MergeTreeWriter(boolean writeBufferSpillable, int sortMaxFan, IOManager ioManager, CompactManager compactManager, long maxSequenceNumber, Comparator<InternalRow> keyComparator, MergeFunction<KeyValue> mergeFunction, KeyValueFileWriterFactory writerFactory, boolean commitForceCompact, CoreOptions.ChangelogProducer changelogProducer, @Nullable CommitIncrement increment, WriterMetrics writerMetrics) {
        this.writeBufferSpillable = writeBufferSpillable;
        this.sortMaxFan = sortMaxFan;
        this.ioManager = ioManager;
        this.keyType = writerFactory.keyType();
        this.valueType = writerFactory.valueType();
        this.compactManager = compactManager;
        this.newSequenceNumber = maxSequenceNumber + 1L;
        this.keyComparator = keyComparator;
        this.mergeFunction = mergeFunction;
        this.writerFactory = writerFactory;
        this.commitForceCompact = commitForceCompact;
        this.changelogProducer = changelogProducer;
        this.newFiles = new LinkedHashSet();
        this.newFilesChangelog = new LinkedHashSet();
        this.compactBefore = new LinkedHashMap();
        this.compactAfter = new LinkedHashSet();
        this.compactChangelog = new LinkedHashSet();
        if (increment != null) {
            this.newFiles.addAll(increment.newFilesIncrement().newFiles());
            this.newFilesChangelog.addAll(increment.newFilesIncrement().changelogFiles());
            increment.compactIncrement().compactBefore().forEach(f -> this.compactBefore.put(f.fileName(), (DataFileMeta)f));
            this.compactAfter.addAll(increment.compactIncrement().compactAfter());
            this.compactChangelog.addAll(increment.compactIncrement().changelogFiles());
        }
        this.writerMetrics = writerMetrics;
    }

    private long newSequenceNumber() {
        return this.newSequenceNumber++;
    }

    @VisibleForTesting
    CompactManager compactManager() {
        return this.compactManager;
    }

    @Override
    public void setMemoryPool(MemorySegmentPool memoryPool) {
        this.writeBuffer = new SortBufferWriteBuffer(this.keyType, this.valueType, memoryPool, this.writeBufferSpillable, this.sortMaxFan, this.ioManager);
    }

    @Override
    public void write(KeyValue kv) throws Exception {
        long sequenceNumber = kv.sequenceNumber() == -1L ? this.newSequenceNumber() : kv.sequenceNumber();
        boolean success = this.writeBuffer.put(sequenceNumber, kv.valueKind(), kv.key(), kv.value());
        if (!success) {
            this.flushWriteBuffer(false, false);
            success = this.writeBuffer.put(sequenceNumber, kv.valueKind(), kv.key(), kv.value());
            if (!success) {
                throw new RuntimeException("Mem table is too small to hold a single element.");
            }
        }
        if (this.writerMetrics != null) {
            this.writerMetrics.incWriteRecordNum();
        }
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
        this.flushWriteBuffer(true, fullCompaction);
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
        files.forEach(this.compactManager::addNewFile);
    }

    @Override
    public Collection<DataFileMeta> dataFiles() {
        return this.compactManager.allFiles();
    }

    @Override
    public long memoryOccupancy() {
        return this.writeBuffer.memoryOccupancy();
    }

    @Override
    public void flushMemory() throws Exception {
        boolean success = this.writeBuffer.flushMemory();
        if (!success) {
            this.flushWriteBuffer(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWriteBuffer(boolean waitForLatestCompaction, boolean forcedFullCompaction) throws Exception {
        long start = System.currentTimeMillis();
        if (this.writeBuffer.size() > 0) {
            if (this.compactManager.shouldWaitForLatestCompaction()) {
                waitForLatestCompaction = true;
            }
            RollingFileWriter<KeyValue, DataFileMeta> changelogWriter = this.changelogProducer == CoreOptions.ChangelogProducer.INPUT ? this.writerFactory.createRollingChangelogFileWriter(0) : null;
            RollingFileWriter<KeyValue, DataFileMeta> dataWriter = this.writerFactory.createRollingMergeTreeFileWriter(0);
            try {
                this.writeBuffer.forEach(this.keyComparator, this.mergeFunction, changelogWriter == null ? null : changelogWriter::write, dataWriter::write);
            }
            finally {
                if (changelogWriter != null) {
                    changelogWriter.close();
                }
                dataWriter.close();
            }
            if (changelogWriter != null) {
                this.newFilesChangelog.addAll((Collection<DataFileMeta>)changelogWriter.result());
            }
            Iterator iterator = dataWriter.result().iterator();
            while (iterator.hasNext()) {
                DataFileMeta fileMeta = (DataFileMeta)iterator.next();
                this.newFiles.add(fileMeta);
                this.compactManager.addNewFile(fileMeta);
            }
            this.writeBuffer.clear();
        }
        this.trySyncLatestCompaction(waitForLatestCompaction);
        this.compactManager.triggerCompaction(forcedFullCompaction);
        if (this.writerMetrics != null) {
            this.writerMetrics.updateBufferFlushCostMillis(System.currentTimeMillis() - start);
        }
    }

    @Override
    public CommitIncrement prepareCommit(boolean waitCompaction) throws Exception {
        long start = System.currentTimeMillis();
        this.flushWriteBuffer(waitCompaction, false);
        this.trySyncLatestCompaction(waitCompaction || this.commitForceCompact || this.compactManager.shouldWaitForPreparingCheckpoint());
        CommitIncrement increment = this.drainIncrement();
        if (this.writerMetrics != null) {
            this.writerMetrics.updatePrepareCommitCostMillis(System.currentTimeMillis() - start);
        }
        return increment;
    }

    @Override
    public void sync() throws Exception {
        this.trySyncLatestCompaction(true);
    }

    private CommitIncrement drainIncrement() {
        NewFilesIncrement newFilesIncrement = new NewFilesIncrement(new ArrayList<DataFileMeta>(this.newFiles), new ArrayList<DataFileMeta>(this.newFilesChangelog));
        CompactIncrement compactIncrement = new CompactIncrement(new ArrayList<DataFileMeta>(this.compactBefore.values()), new ArrayList<DataFileMeta>(this.compactAfter), new ArrayList<DataFileMeta>(this.compactChangelog));
        this.newFiles.clear();
        this.newFilesChangelog.clear();
        this.compactBefore.clear();
        this.compactAfter.clear();
        this.compactChangelog.clear();
        return new CommitIncrement(newFilesIncrement, compactIncrement);
    }

    private void updateCompactResult(CompactResult result) {
        Set afterFiles = result.after().stream().map(DataFileMeta::fileName).collect(Collectors.toSet());
        for (DataFileMeta file : result.before()) {
            if (this.compactAfter.remove(file)) {
                if (this.compactBefore.containsKey(file.fileName()) || afterFiles.contains(file.fileName())) continue;
                this.writerFactory.deleteFile(file.fileName(), file.level());
                continue;
            }
            this.compactBefore.put(file.fileName(), file);
        }
        this.compactAfter.addAll(result.after());
        this.compactChangelog.addAll(result.changelog());
    }

    private void trySyncLatestCompaction(boolean blocking) throws Exception {
        Optional<CompactResult> result = this.compactManager.getCompactionResult(blocking);
        result.ifPresent(this::updateCompactResult);
    }

    @Override
    public void close() throws Exception {
        if (this.writerMetrics != null) {
            this.writerMetrics.close();
        }
        this.compactManager.cancelCompaction();
        this.sync();
        this.compactManager.close();
        ArrayList<DataFileMeta> delete = new ArrayList<DataFileMeta>(this.newFiles);
        this.newFiles.clear();
        for (DataFileMeta file : this.newFilesChangelog) {
            this.writerFactory.deleteFile(file.fileName(), file.level());
        }
        this.newFilesChangelog.clear();
        for (DataFileMeta file : this.compactAfter) {
            if (this.compactBefore.containsKey(file.fileName())) continue;
            delete.add(file);
        }
        this.compactAfter.clear();
        for (DataFileMeta file : this.compactChangelog) {
            this.writerFactory.deleteFile(file.fileName(), file.level());
        }
        this.compactChangelog.clear();
        for (DataFileMeta file : delete) {
            this.writerFactory.deleteFile(file.fileName(), file.level());
        }
    }
}

