/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsConverters fieldKeyStatsConverters;
    private final FieldStatsConverters fieldValueStatsConverters;
    private Predicate keyFilter;
    private Predicate valueFilter;

    public KeyValueFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism);
        this.fieldKeyStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.keyFields(this.scanTableSchema((long)sid)), schemaId);
        this.fieldValueStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.valueFields(this.scanTableSchema((long)sid)), schemaId);
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    public KeyValueFileStoreScan withValueFilter(Predicate predicate) {
        this.valueFilter = predicate;
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.keyFilter == null || this.keyFilter.test(entry.file().rowCount(), entry.file().keyStats().fields(this.fieldKeyStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()));
    }

    @Override
    protected boolean filterWholeBucketByStats(List<ManifestEntry> entries) {
        if (this.valueFilter != null) {
            for (ManifestEntry entry : entries) {
                if (!this.valueFilter.test(entry.file().rowCount(), entry.file().valueStats().fields(this.fieldValueStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()))) continue;
                return true;
            }
        }
        return this.valueFilter == null;
    }
}

