/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.options.FallbackKey;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.utils.Preconditions;

@Public
public class ConfigOption<T> {
    private static final FallbackKey[] EMPTY = new FallbackKey[0];
    static final Description EMPTY_DESCRIPTION = Description.builder().text("").build();
    private final String key;
    private final FallbackKey[] fallbackKeys;
    private final T defaultValue;
    private final Description description;
    private final Class<?> clazz;
    private final boolean isList;

    Class<?> getClazz() {
        return this.clazz;
    }

    boolean isList() {
        return this.isList;
    }

    ConfigOption(String key, Class<?> clazz, Description description, T defaultValue, boolean isList, FallbackKey ... fallbackKeys) {
        this.key = Preconditions.checkNotNull(key);
        this.description = description;
        this.defaultValue = defaultValue;
        this.fallbackKeys = fallbackKeys == null || fallbackKeys.length == 0 ? EMPTY : fallbackKeys;
        this.clazz = Preconditions.checkNotNull(clazz);
        this.isList = isList;
    }

    public ConfigOption<T> withFallbackKeys(String ... fallbackKeys) {
        Stream<FallbackKey> newFallbackKeys = Arrays.stream(fallbackKeys).map(FallbackKey::createFallbackKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(newFallbackKeys, currentAlternativeKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.clazz, this.description, this.defaultValue, this.isList, mergedAlternativeKeys);
    }

    public ConfigOption<T> withDeprecatedKeys(String ... deprecatedKeys) {
        Stream<FallbackKey> newDeprecatedKeys = Arrays.stream(deprecatedKeys).map(FallbackKey::createDeprecatedKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(currentAlternativeKeys, newDeprecatedKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.clazz, this.description, this.defaultValue, this.isList, mergedAlternativeKeys);
    }

    public ConfigOption<T> withDescription(String description) {
        return this.withDescription(Description.builder().text(description).build());
    }

    public ConfigOption<T> withDescription(Description description) {
        return new ConfigOption<T>(this.key, this.clazz, description, this.defaultValue, this.isList, this.fallbackKeys);
    }

    public String key() {
        return this.key;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public boolean hasDeprecatedKeys() {
        return this.fallbackKeys != EMPTY && Arrays.stream(this.fallbackKeys).anyMatch(FallbackKey::isDeprecated);
    }

    @Deprecated
    public Iterable<String> deprecatedKeys() {
        return this.fallbackKeys == EMPTY ? Collections.emptyList() : (Iterable)Arrays.stream(this.fallbackKeys).filter(FallbackKey::isDeprecated).map(FallbackKey::getKey).collect(Collectors.toList());
    }

    public boolean hasFallbackKeys() {
        return this.fallbackKeys != EMPTY;
    }

    public Iterable<FallbackKey> fallbackKeys() {
        return this.fallbackKeys == EMPTY ? Collections.emptyList() : Arrays.asList(this.fallbackKeys);
    }

    public Description description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == ConfigOption.class) {
            ConfigOption that = (ConfigOption)o;
            return this.key.equals(that.key) && Arrays.equals(this.fallbackKeys, that.fallbackKeys) && (this.defaultValue == null ? that.defaultValue == null : that.defaultValue != null && this.defaultValue.equals(that.defaultValue));
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + 17 * Arrays.hashCode(this.fallbackKeys) + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s (fallback keys: %s)", this.key, this.defaultValue, Arrays.toString(this.fallbackKeys));
    }
}

