/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.FunctionVisitor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;

public class CompoundPredicate
implements Predicate {
    private final Function function;
    private final List<Predicate> children;

    public CompoundPredicate(Function function, List<Predicate> children) {
        this.function = function;
        this.children = children;
    }

    public Function function() {
        return this.function;
    }

    public List<Predicate> children() {
        return this.children;
    }

    @Override
    public boolean test(Object[] values) {
        return this.function.test(values, this.children);
    }

    @Override
    public boolean test(InternalRow row) {
        return this.function.test(row, this.children);
    }

    @Override
    public boolean test(long rowCount, FieldStats[] fieldStats) {
        return this.function.test(rowCount, fieldStats, this.children);
    }

    @Override
    public Optional<Predicate> negate() {
        return this.function.negate(this.children);
    }

    @Override
    public <T> T visit(PredicateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompoundPredicate)) {
            return false;
        }
        CompoundPredicate that = (CompoundPredicate)o;
        return Objects.equals(this.function, that.function) && Objects.equals(this.children, that.children);
    }

    public static abstract class Function
    implements Serializable {
        public abstract boolean test(Object[] var1, List<Predicate> var2);

        public abstract boolean test(InternalRow var1, List<Predicate> var2);

        public abstract boolean test(long var1, FieldStats[] var3, List<Predicate> var4);

        public abstract Optional<Predicate> negate(List<Predicate> var1);

        public abstract <T> T visit(FunctionVisitor<T> var1, List<T> var2);

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }
}

