/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.FunctionVisitor;
import org.apache.paimon.predicate.IsNull;
import org.apache.paimon.predicate.LeafFunction;
import org.apache.paimon.predicate.LeafUnaryFunction;
import org.apache.paimon.types.DataType;

public class IsNotNull
extends LeafUnaryFunction {
    public static final IsNotNull INSTANCE = new IsNotNull();

    private IsNotNull() {
    }

    @Override
    public boolean test(DataType type, Object field) {
        return field != null;
    }

    @Override
    public boolean test(DataType type, long rowCount, FieldStats fieldStats) {
        Long nullCount = fieldStats.nullCount();
        return nullCount == null || nullCount < rowCount;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(IsNull.INSTANCE);
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitIsNotNull(fieldRef);
    }
}

