/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.metastore.AddPartitionCommitCallback;
import org.apache.paimon.metastore.AddPartitionTagCallback;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.metastore.TagPreviewCommitCallback;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.RollbackHelper;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.DynamicBucketRowKeyExtractor;
import org.apache.paimon.table.sink.FixedBucketRowKeyExtractor;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.table.sink.UnawareBucketRowKeyExtractor;
import org.apache.paimon.table.source.InnerStreamTableScan;
import org.apache.paimon.table.source.InnerStreamTableScanImpl;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.InnerTableScanImpl;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.SnapshotReaderImpl;
import org.apache.paimon.table.source.snapshot.StaticFromTimestampStartingScanner;
import org.apache.paimon.tag.TagPreview;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public abstract class AbstractFileStoreTable
implements FileStoreTable {
    private static final long serialVersionUID = 1L;
    protected final FileIO fileIO;
    protected final Path path;
    protected final TableSchema tableSchema;
    protected final CatalogEnvironment catalogEnvironment;

    public AbstractFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        this.fileIO = fileIO;
        this.path = path;
        if (!tableSchema.options().containsKey(CoreOptions.PATH.key())) {
            HashMap<String, String> newOptions = new HashMap<String, String>(tableSchema.options());
            newOptions.put(CoreOptions.PATH.key(), path.toString());
            tableSchema = tableSchema.copy(newOptions);
        }
        this.tableSchema = tableSchema;
        this.catalogEnvironment = catalogEnvironment;
    }

    @Override
    public BucketMode bucketMode() {
        return this.store().bucketMode();
    }

    @Override
    public CatalogEnvironment catalogEnvironment() {
        return this.catalogEnvironment;
    }

    public RowKeyExtractor createRowKeyExtractor() {
        switch (this.bucketMode()) {
            case FIXED: {
                return new FixedBucketRowKeyExtractor(this.schema());
            }
            case DYNAMIC: 
            case GLOBAL_DYNAMIC: {
                return new DynamicBucketRowKeyExtractor(this.schema());
            }
            case UNAWARE: {
                return new UnawareBucketRowKeyExtractor(this.schema());
            }
        }
        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)this.bucketMode()));
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return new SnapshotReaderImpl(this.store().newScan(), this.tableSchema, this.coreOptions(), this.snapshotManager(), this.splitGenerator(), this.nonPartitionFilterConsumer(), DefaultValueAssigner.create(this.tableSchema), this.store().pathFactory(), this.name());
    }

    @Override
    public InnerTableScan newScan() {
        return new InnerTableScanImpl(this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), DefaultValueAssigner.create(this.tableSchema));
    }

    @Override
    public InnerStreamTableScan newStreamScan() {
        return new InnerStreamTableScanImpl(this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), this.supportStreamingReadOverwrite(), DefaultValueAssigner.create(this.tableSchema));
    }

    public abstract SplitGenerator splitGenerator();

    public abstract boolean supportStreamingReadOverwrite();

    public abstract BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer();

    protected abstract FileStoreTable copy(TableSchema var1);

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        Map<String, String> options = this.tableSchema.options();
        dynamicOptions.forEach((k, v) -> {
            if (!Objects.equals(v, options.get(k))) {
                SchemaManager.checkAlterTableOption(k);
            }
        });
        return this.internalCopyWithoutCheck(dynamicOptions);
    }

    @Override
    public FileStoreTable internalCopyWithoutCheck(Map<String, String> dynamicOptions) {
        HashMap<String, String> options = new HashMap<String, String>(this.tableSchema.options());
        dynamicOptions.forEach((k, v) -> {
            if (v == null) {
                options.remove(k);
            } else {
                options.put((String)k, (String)v);
            }
        });
        Options newOptions = Options.fromMap(options);
        newOptions.set(CoreOptions.PATH, this.path.toString());
        CoreOptions.setDefaultValues(newOptions);
        TableSchema newTableSchema = this.tableSchema.copy(newOptions.toMap());
        SchemaValidation.validateTableSchema(newTableSchema);
        newTableSchema = this.tryTimeTravel(newOptions).orElse(newTableSchema);
        return this.copy(newTableSchema);
    }

    @Override
    public FileStoreTable copyWithLatestSchema() {
        Map<String, String> options = this.tableSchema.options();
        SchemaManager schemaManager = new SchemaManager(this.fileIO(), this.location());
        Optional<TableSchema> optionalLatestSchema = schemaManager.latest();
        if (optionalLatestSchema.isPresent()) {
            TableSchema newTableSchema = optionalLatestSchema.get();
            newTableSchema = newTableSchema.copy(options);
            SchemaValidation.validateTableSchema(newTableSchema);
            return this.copy(newTableSchema);
        }
        return this;
    }

    protected SchemaManager schemaManager() {
        return new SchemaManager(this.fileIO(), this.path);
    }

    @Override
    public CoreOptions coreOptions() {
        return this.store().options();
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    @Override
    public Path location() {
        return this.path;
    }

    @Override
    public TableSchema schema() {
        return this.tableSchema;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.store().snapshotManager();
    }

    @Override
    public TableCommitImpl newCommit(String commitUser) {
        return new TableCommitImpl(this.store().newCommit(commitUser), this.createCommitCallbacks(), this.coreOptions().writeOnly() ? null : this.store().newExpire(), this.coreOptions().writeOnly() ? null : this.store().newPartitionExpire(commitUser), this.coreOptions().writeOnly() ? null : this.store().newTagCreationManager(), this.catalogEnvironment.lockFactory().create(), CoreOptions.fromMap(this.options()).consumerExpireTime(), new ConsumerManager(this.fileIO, this.path), this.coreOptions().snapshotExpireExecutionMode(), this.name());
    }

    private List<CommitCallback> createCommitCallbacks() {
        ArrayList<CommitCallback> callbacks = new ArrayList<CommitCallback>(this.loadCommitCallbacks());
        CoreOptions options = this.coreOptions();
        MetastoreClient.Factory metastoreClientFactory = this.catalogEnvironment.metastoreClientFactory();
        if (options.partitionedTableInMetastore() && metastoreClientFactory != null && this.tableSchema.partitionKeys().size() > 0) {
            callbacks.add(new AddPartitionCommitCallback(metastoreClientFactory.create()));
        }
        TagPreview tagPreview = TagPreview.create(options);
        if (options.tagToPartitionField() != null && tagPreview != null && metastoreClientFactory != null && this.tableSchema.partitionKeys().isEmpty()) {
            TagPreviewCommitCallback callback = new TagPreviewCommitCallback(new AddPartitionTagCallback(metastoreClientFactory.create(), options.tagToPartitionField()), tagPreview);
            callbacks.add(callback);
        }
        return callbacks;
    }

    private List<TagCallback> createTagCallbacks() {
        ArrayList<TagCallback> callbacks = new ArrayList<TagCallback>(this.loadTagCallbacks());
        String partitionField = this.coreOptions().tagToPartitionField();
        MetastoreClient.Factory metastoreClientFactory = this.catalogEnvironment.metastoreClientFactory();
        if (partitionField != null && metastoreClientFactory != null) {
            callbacks.add(new AddPartitionTagCallback(metastoreClientFactory.create(), partitionField));
        }
        return callbacks;
    }

    private List<TagCallback> loadTagCallbacks() {
        return this.loadCallbacks(this.coreOptions().tagCallbacks(), TagCallback.class);
    }

    private List<CommitCallback> loadCommitCallbacks() {
        return this.loadCallbacks(this.coreOptions().commitCallbacks(), CommitCallback.class);
    }

    private <T> List<T> loadCallbacks(Map<String, String> clazzParamMaps, Class<T> expectClass) {
        ArrayList result = new ArrayList();
        for (Map.Entry<String, String> classParamEntry : clazzParamMaps.entrySet()) {
            Class<?> clazz;
            String className = classParamEntry.getKey();
            String param = classParamEntry.getValue();
            try {
                clazz = Class.forName(className, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Preconditions.checkArgument(expectClass.isAssignableFrom(clazz), "Class " + clazz + " must implement " + expectClass);
            try {
                if (param == null) {
                    result.add(clazz.newInstance());
                    continue;
                }
                result.add(clazz.getConstructor(String.class).newInstance(param));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize commit callback " + className + (param == null ? "" : " with param " + param), e);
            }
        }
        return result;
    }

    private Optional<TableSchema> tryTimeTravel(Options options) {
        CoreOptions coreOptions = new CoreOptions(options);
        switch (coreOptions.startupMode()) {
            case FROM_SNAPSHOT: 
            case FROM_SNAPSHOT_FULL: {
                if (coreOptions.scanSnapshotId() != null) {
                    long snapshotId = coreOptions.scanSnapshotId();
                    if (this.snapshotManager().snapshotExists(snapshotId)) {
                        long schemaId = this.snapshotManager().snapshot(snapshotId).schemaId();
                        return Optional.of(this.schemaManager().schema(schemaId).copy(options.toMap()));
                    }
                } else {
                    String tagName = coreOptions.scanTagName();
                    TagManager tagManager = this.tagManager();
                    if (tagManager.tagExists(tagName)) {
                        long schemaId = tagManager.taggedSnapshot(tagName).schemaId();
                        return Optional.of(this.schemaManager().schema(schemaId).copy(options.toMap()));
                    }
                }
                return Optional.empty();
            }
            case FROM_TIMESTAMP: {
                Snapshot snapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(this.snapshotManager(), coreOptions.scanTimestampMills());
                if (snapshot != null) {
                    long schemaId = snapshot.schemaId();
                    return Optional.of(this.schemaManager().schema(schemaId).copy(options.toMap()));
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public void rollbackTo(long snapshotId) {
        SnapshotManager snapshotManager = this.snapshotManager();
        Preconditions.checkArgument(snapshotManager.snapshotExists(snapshotId), "Rollback snapshot '%s' doesn't exist.", snapshotId);
        this.rollbackHelper().cleanLargerThan(snapshotManager.snapshot(snapshotId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTag(String tagName, long fromSnapshotId) {
        SnapshotManager snapshotManager = this.snapshotManager();
        Preconditions.checkArgument(snapshotManager.snapshotExists(fromSnapshotId), "Cannot create tag because given snapshot #%s doesn't exist.", fromSnapshotId);
        Snapshot snapshot = snapshotManager.snapshot(fromSnapshotId);
        this.tagManager().createTag(snapshot, tagName);
        List<Object> callbacks = Collections.emptyList();
        try {
            callbacks = this.createTagCallbacks();
            callbacks.forEach(callback -> callback.notifyCreation(tagName));
        }
        finally {
            for (TagCallback tagCallback : callbacks) {
                IOUtils.closeQuietly(tagCallback);
            }
        }
    }

    @Override
    public void deleteTag(String tagName) {
        this.tagManager().deleteTag(tagName, this.store().newTagDeletion(), this.snapshotManager());
    }

    @Override
    public void rollbackTo(String tagName) {
        TagManager tagManager = this.tagManager();
        Preconditions.checkArgument(tagManager.tagExists(tagName), "Rollback tag '%s' doesn't exist.", tagName);
        Snapshot taggedSnapshot = tagManager.taggedSnapshot(tagName);
        this.rollbackHelper().cleanLargerThan(taggedSnapshot);
        try {
            SnapshotManager snapshotManager = this.snapshotManager();
            if (!snapshotManager.snapshotExists(taggedSnapshot.id())) {
                this.fileIO.writeFileUtf8(this.snapshotManager().snapshotPath(taggedSnapshot.id()), this.fileIO.readFileUtf8(tagManager.tagPath(tagName)));
                snapshotManager.commitEarliestHint(taggedSnapshot.id());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public TagManager tagManager() {
        return new TagManager(this.fileIO, this.path);
    }

    private RollbackHelper rollbackHelper() {
        return new RollbackHelper(this.snapshotManager(), this.tagManager(), this.fileIO, this.store().newSnapshotDeletion(), this.store().newTagDeletion());
    }
}

