/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueFileStore;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.mergetree.compact.LookupMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PrimaryKeyTableUtils;
import org.apache.paimon.table.sink.SequenceGenerator;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.MergeTreeSplitGenerator;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.ValueContentRowDataRecordIterator;
import org.apache.paimon.types.RowType;

public class PrimaryKeyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient KeyValueFileStore lazyStore;

    PrimaryKeyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this(fileIO, path, tableSchema, new CatalogEnvironment(Lock.emptyFactory(), null, null));
    }

    PrimaryKeyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        super(fileIO, path, tableSchema, catalogEnvironment);
    }

    @Override
    protected FileStoreTable copy(TableSchema newTableSchema) {
        return new PrimaryKeyFileStoreTable(this.fileIO, this.path, newTableSchema, this.catalogEnvironment);
    }

    public KeyValueFileStore store() {
        if (this.lazyStore == null) {
            RowType rowType = this.tableSchema.logicalRowType();
            Options conf = Options.fromMap(this.tableSchema.options());
            CoreOptions options = new CoreOptions(conf);
            PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor extractor = PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor.EXTRACTOR;
            MergeFunctionFactory<KeyValue> mfFactory = PrimaryKeyTableUtils.createMergeFunctionFactory(this.tableSchema, extractor);
            if (options.changelogProducer() == CoreOptions.ChangelogProducer.LOOKUP) {
                mfFactory = LookupMergeFunction.wrap(mfFactory, new RowType(extractor.keyFields(this.tableSchema)), rowType);
            }
            this.lazyStore = new KeyValueFileStore(this.fileIO(), this.schemaManager(), this.tableSchema.id(), this.tableSchema.crossPartitionUpdate(), options, this.tableSchema.logicalPartitionType(), PrimaryKeyTableUtils.addKeyNamePrefix(this.tableSchema.logicalBucketKeyType()), new RowType(extractor.keyFields(this.tableSchema)), rowType, extractor, mfFactory, this.name());
        }
        return this.lazyStore;
    }

    @Override
    public SplitGenerator splitGenerator() {
        return new MergeTreeSplitGenerator(this.store().newKeyComparator(), this.store().options().splitTargetSize(), this.store().options().splitOpenFileCost());
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return new CoreOptions(this.tableSchema.options()).streamingReadOverwrite();
    }

    @Override
    public BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer() {
        return (scan, predicate) -> {
            List<Predicate> keyFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.tableSchema.fieldNames(), this.tableSchema.trimmedPrimaryKeys());
            if (keyFilters.size() > 0) {
                ((KeyValueFileStoreScan)scan).withKeyFilter(PredicateBuilder.and(keyFilters));
            }
            ((KeyValueFileStoreScan)scan).withValueFilter((Predicate)predicate);
        };
    }

    @Override
    public InnerTableRead newRead() {
        return new KeyValueTableRead(this.store().newRead(), this.schema()){

            @Override
            public void projection(int[][] projection) {
                this.read.withValueProjection(projection);
            }

            @Override
            protected RecordReader.RecordIterator<InternalRow> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> kvRecordIterator) {
                return new ValueContentRowDataRecordIterator(kvRecordIterator);
            }

            @Override
            public InnerTableRead forceKeepDelete() {
                this.read.forceKeepDelete();
                return this;
            }
        };
    }

    @Override
    public TableWriteImpl<KeyValue> newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public TableWriteImpl<KeyValue> newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        SequenceGenerator sequenceGenerator = SequenceGenerator.create(this.schema(), this.store().options());
        KeyValue kv = new KeyValue();
        return new TableWriteImpl<KeyValue>(this.store().newWrite(commitUser, manifestFilter), this.createRowKeyExtractor(), record -> {
            long sequenceNumber = sequenceGenerator == null ? -1L : sequenceGenerator.generate(record.row());
            return kv.replace(record.primaryKey(), sequenceNumber, record.row().getRowKind(), record.row());
        }, this.name());
    }
}

