/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerStreamTableScan;
import org.apache.paimon.table.source.InnerStreamTableScanImpl;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.InnerTableScanImpl;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class ReadOptimizedTable
implements DataTable,
ReadonlyTable {
    public static final String READ_OPTIMIZED = "ro";
    private final AbstractFileStoreTable dataTable;

    public ReadOptimizedTable(FileStoreTable dataTable) {
        this.dataTable = (AbstractFileStoreTable)dataTable;
    }

    @Override
    public String name() {
        return this.dataTable.name() + "$" + READ_OPTIMIZED;
    }

    @Override
    public RowType rowType() {
        return this.dataTable.rowType();
    }

    @Override
    public List<String> partitionKeys() {
        return this.dataTable.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.dataTable.options();
    }

    @Override
    public List<String> primaryKeys() {
        return this.dataTable.primaryKeys();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        if (this.dataTable.schema().primaryKeys().size() > 0) {
            return this.dataTable.newSnapshotReader().withLevelFilter(level -> level == this.coreOptions().numLevels() - 1);
        }
        return this.dataTable.newSnapshotReader();
    }

    @Override
    public InnerTableScan newScan() {
        return new InnerTableScanImpl(this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), DefaultValueAssigner.create(this.dataTable.schema()));
    }

    @Override
    public InnerStreamTableScan newStreamScan() {
        return new InnerStreamTableScanImpl(this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), this.dataTable.supportStreamingReadOverwrite(), DefaultValueAssigner.create(this.dataTable.schema()));
    }

    @Override
    public CoreOptions coreOptions() {
        return this.dataTable.coreOptions();
    }

    @Override
    public Path location() {
        return this.dataTable.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.dataTable.snapshotManager();
    }

    @Override
    public TagManager tagManager() {
        return this.dataTable.tagManager();
    }

    @Override
    public InnerTableRead newRead() {
        return this.dataTable.newRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new ReadOptimizedTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }
}

