/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Stream;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.ObjectSerializer;

public class FileUtils {
    public static final ForkJoinPool COMMON_IO_FORK_JOIN_POOL;

    public static <T> List<T> readListFromFile(FileIO fileIO, Path path, ObjectSerializer<T> serializer, FormatReaderFactory readerFactory) throws IOException {
        ArrayList result = new ArrayList();
        FileUtils.createFormatReader(fileIO, readerFactory, path).forEachRemaining(row -> result.add(serializer.fromRow((InternalRow)row)));
        return result;
    }

    public static Stream<Long> listVersionedFiles(FileIO fileIO, Path dir, String prefix) throws IOException {
        return FileUtils.listOriginalVersionedFiles(fileIO, dir, prefix).map(Long::parseLong);
    }

    public static Stream<String> listOriginalVersionedFiles(FileIO fileIO, Path dir, String prefix) throws IOException {
        return FileUtils.listVersionedFileStatus(fileIO, dir, prefix).map(FileStatus::getPath).map(Path::getName).map(name -> name.substring(prefix.length()));
    }

    public static Stream<FileStatus> listVersionedFileStatus(FileIO fileIO, Path dir, String prefix) throws IOException {
        if (!fileIO.exists(dir)) {
            return Stream.empty();
        }
        FileStatus[] statuses = fileIO.listStatus(dir);
        if (statuses == null) {
            throw new RuntimeException(String.format("The return value is null of the listStatus for the '%s' directory.", dir));
        }
        return Arrays.stream(statuses).filter(status -> status.getPath().getName().startsWith(prefix));
    }

    public static void checkExists(FileIO fileIO, Path file) throws IOException {
        if (!fileIO.exists(file)) {
            throw new FileNotFoundException(String.format("File '%s' not found, Possible causes: 1.snapshot expires too fast, you can configure 'snapshot.time-retained' option with a larger value. 2.consumption is too slow, you can improve the performance of consumption (For example, increasing parallelism).", file));
        }
    }

    public static RecordReader<InternalRow> createFormatReader(FileIO fileIO, FormatReaderFactory format, Path file) throws IOException {
        FileUtils.checkExists(fileIO, file);
        return format.createReader(fileIO, file);
    }

    static {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("file-store-common-io-" + worker.getPoolIndex());
            return worker;
        };
        COMMON_IO_FORK_JOIN_POOL = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), factory, null, false);
    }
}

