/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CreateTagAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class CreateTagActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "create_tag";
    private static final String TAG_NAME = "tag_name";
    private static final String SNAPSHOT = "snapshot";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        this.checkRequiredArgument(params, TAG_NAME);
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        String tagName = params.get(TAG_NAME);
        Long snapshot = null;
        if (params.has(SNAPSHOT)) {
            snapshot = Long.parseLong(params.get(SNAPSHOT));
        }
        CreateTagAction action = new CreateTagAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, tagName, snapshot);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"create_tag\" creates a tag from given snapshot.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  create_tag --warehouse <warehouse_path> --database <database_name> --table <table_name> --tag_name <tag_name> [--snapshot <snapshot_id>]");
        System.out.println();
    }
}

