/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.cdc.SyncTableActionBase;
import org.apache.paimon.flink.action.cdc.TypeMapping;

public abstract class SyncTableActionFactoryBase
implements ActionFactory {
    protected Tuple3<String, String, String> tablePath;
    protected Map<String, String> catalogConfig;
    protected Map<String, String> cdcSourceConfig;

    public abstract String cdcConfigIdentifier();

    public abstract SyncTableActionBase createAction();

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        this.checkRequiredArgument(params, this.cdcConfigIdentifier());
        this.tablePath = this.getTablePath(params);
        this.catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        this.cdcSourceConfig = this.optionalConfigMap(params, this.cdcConfigIdentifier());
        SyncTableActionBase action = this.createAction();
        action.withTableConfig(this.optionalConfigMap(params, "table_conf"));
        this.withParams(params, action);
        return Optional.of(action);
    }

    protected void withParams(MultipleParameterToolAdapter params, SyncTableActionBase action) {
        if (params.has("partition_keys")) {
            action.withPartitionKeys(params.get("partition_keys").split(","));
        }
        if (params.has("primary_keys")) {
            action.withPrimaryKeys(params.get("primary_keys").split(","));
        }
        if (params.has("computed_column")) {
            action.withComputedColumnArgs(new ArrayList<String>(params.getMultiParameter("computed_column")));
        }
        if (params.has("metadata_column")) {
            ArrayList<String> metadataColumns = new ArrayList<String>(params.getMultiParameter("metadata_column"));
            if (metadataColumns.size() == 1) {
                action.withMetadataColumns(Arrays.asList(((String)metadataColumns.get(0)).split(",")));
            } else {
                action.withMetadataColumns(new ArrayList<String>(params.getMultiParameter("metadata_column")));
            }
        }
        if (params.has("type_mapping")) {
            String[] options = params.get("type_mapping").split(",");
            action.withTypeMapping(TypeMapping.parse(options));
        }
    }
}

