/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.io.SplitsParallelReadUtil;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateFilter;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.primitives.Ints;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.TypeUtils;

public class TableStreamingReader {
    private final Table table;
    private final int[] projection;
    private final ReadBuilder readBuilder;
    @Nullable
    private final PredicateFilter recordFilter;
    private final StreamTableScan scan;

    public TableStreamingReader(Table table, int[] projection, @Nullable Predicate predicate) {
        this.table = table;
        this.projection = projection;
        if (CoreOptions.fromMap(table.options()).startupMode() != CoreOptions.StartupMode.COMPACTED_FULL) {
            table = table.copy(Collections.singletonMap(CoreOptions.SCAN_MODE.key(), CoreOptions.StartupMode.LATEST_FULL.toString()));
        }
        this.readBuilder = table.newReadBuilder().withProjection(projection).withFilter(predicate);
        this.scan = this.readBuilder.newStreamScan();
        if (predicate != null) {
            List<String> fieldNames = table.rowType().getFieldNames();
            List<String> primaryKeys = table.primaryKeys();
            IntUnaryOperator operator = i -> {
                int index = Ints.indexOf(projection, i);
                boolean safeFilter = primaryKeys.isEmpty() || primaryKeys.contains(fieldNames.get(i));
                return safeFilter ? index : -1;
            };
            int[] fieldIdxToProjectionIdx = IntStream.range(0, table.rowType().getFieldCount()).map(operator).toArray();
            this.recordFilter = new PredicateFilter(TypeUtils.project(table.rowType(), projection), PredicateBuilder.transformFieldMapping(predicate, fieldIdxToProjectionIdx).orElse(null));
        } else {
            this.recordFilter = null;
        }
    }

    public RecordReader<InternalRow> nextBatch(boolean useParallelism, boolean readSequenceNumber) throws Exception {
        RecordReader<InternalRow> reader;
        List<Split> splits = this.scan.plan().splits();
        CoreOptions options = CoreOptions.fromMap(this.table.options());
        FunctionWithIOException readerSupplier = readSequenceNumber ? this.createReaderWithSequenceSupplier() : split -> this.readBuilder.newRead().createReader((Split)split);
        RowType readType = TypeUtils.project(this.table.rowType(), this.projection);
        if (readSequenceNumber) {
            readType = readType.appendDataField("_SEQUENCE_NUMBER", DataTypes.BIGINT());
        }
        if (useParallelism) {
            reader = SplitsParallelReadUtil.parallelExecute(readType, readerSupplier, splits, options.pageSize(), new Options(this.table.options()).get(FlinkConnectorOptions.LOOKUP_BOOTSTRAP_PARALLELISM));
        } else {
            ArrayList readers = new ArrayList();
            for (Split split2 : splits) {
                readers.add(() -> (RecordReader)readerSupplier.apply(split2));
            }
            reader = ConcatRecordReader.create(readers);
        }
        if (this.recordFilter != null) {
            reader = reader.filter(this.recordFilter::test);
        }
        return reader;
    }

    private FunctionWithIOException<Split, RecordReader<InternalRow>> createReaderWithSequenceSupplier() {
        return split -> {
            TableRead read = this.readBuilder.newRead();
            if (!(read instanceof KeyValueTableRead)) {
                throw new IllegalArgumentException("Only KeyValueTableRead supports sequence read, but it is: " + read);
            }
            KeyValueTableRead kvRead = (KeyValueTableRead)read;
            JoinedRow reused = new JoinedRow();
            return kvRead.kvReader((Split)split).transform(kv -> {
                reused.replace(kv.value(), GenericRow.of(kv.sequenceNumber()));
                reused.setRowKind(kv.valueKind());
                return reused;
            });
        };
    }
}

