/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;

public class CdcWithBucketChannelComputer
implements ChannelComputer<Tuple2<CdcRecord, Integer>> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient CdcRecordKeyAndBucketExtractor extractor;

    public CdcWithBucketChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new CdcRecordKeyAndBucketExtractor(this.schema);
    }

    @Override
    public int channel(Tuple2<CdcRecord, Integer> record) {
        this.extractor.setRecord((CdcRecord)record.f0);
        return ChannelComputer.select(this.extractor.partition(), (Integer)record.f1, this.numChannels);
    }

    public String toString() {
        return "shuffle by partition & bucket";
    }
}

