/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.paimon.flink.action.cdc.CdcActionCommonUtils;
import org.apache.paimon.flink.action.cdc.CdcMetadataConverter;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataType;

public class NewTableSchemaBuilder
implements Serializable {
    private final Map<String, String> tableConfig;
    private final boolean caseSensitive;
    private final CdcMetadataConverter[] metadataConverters;

    public NewTableSchemaBuilder(Map<String, String> tableConfig, boolean caseSensitive, CdcMetadataConverter[] metadataConverters) {
        this.tableConfig = tableConfig;
        this.caseSensitive = caseSensitive;
        this.metadataConverters = metadataConverters;
    }

    public Optional<Schema> build(RichCdcMultiplexRecord record) {
        Schema.Builder builder = Schema.newBuilder();
        builder.options(this.tableConfig);
        String tableName = record.tableName();
        tableName = tableName == null ? "UNKNOWN" : tableName;
        HashSet<String> existedFields = new HashSet<String>();
        Function<String, String> columnDuplicateErrMsg = CdcActionCommonUtils.columnDuplicateErrMsg(tableName);
        for (Map.Entry<String, DataType> entry : record.fieldTypes().entrySet()) {
            String fieldName = CdcActionCommonUtils.columnCaseConvertAndDuplicateCheck(entry.getKey(), existedFields, this.caseSensitive, columnDuplicateErrMsg);
            builder.column(fieldName, entry.getValue());
        }
        for (CdcMetadataConverter metadataConverter : this.metadataConverters) {
            String metadataColumnName = CdcActionCommonUtils.columnCaseConvertAndDuplicateCheck(metadataConverter.columnName(), existedFields, this.caseSensitive, columnDuplicateErrMsg);
            builder.column(metadataColumnName, metadataConverter.dataType());
        }
        builder.primaryKey(CdcActionCommonUtils.listCaseConvert(record.primaryKeys(), this.caseSensitive));
        return Optional.of(builder.build());
    }
}

