/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.source.ContinuousFileStoreSource;
import org.apache.paimon.flink.source.FlinkSource;
import org.apache.paimon.flink.source.FlinkTableSource;
import org.apache.paimon.flink.source.StaticFileStoreSource;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.ReadBuilder;

public class SystemTableSource
extends FlinkTableSource {
    private final boolean isStreamingMode;
    private final int splitBatchSize;
    private final FlinkConnectorOptions.SplitAssignMode splitAssignMode;

    public SystemTableSource(Table table, boolean isStreamingMode) {
        super(table);
        this.isStreamingMode = isStreamingMode;
        Options options = Options.fromMap(table.options());
        this.splitBatchSize = options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_BATCH_SIZE);
        this.splitAssignMode = options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_ASSIGN_MODE);
    }

    public SystemTableSource(Table table, boolean isStreamingMode, @Nullable Predicate predicate, @Nullable int[][] projectFields, @Nullable Long limit, int splitBatchSize, FlinkConnectorOptions.SplitAssignMode splitAssignMode) {
        super(table, predicate, projectFields, limit);
        this.isStreamingMode = isStreamingMode;
        this.splitBatchSize = splitBatchSize;
        this.splitAssignMode = splitAssignMode;
    }

    @Override
    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    @Override
    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        ReadBuilder readBuilder = this.table.newReadBuilder().withProjection(this.projectFields).withFilter(this.predicate);
        FlinkSource source = this.isStreamingMode && this.table instanceof DataTable ? new ContinuousFileStoreSource(readBuilder, this.table.options(), this.limit) : new StaticFileStoreSource(readBuilder, this.limit, this.splitBatchSize, this.splitAssignMode);
        return SourceProvider.of((Source)source);
    }

    @Override
    public SystemTableSource copy() {
        return new SystemTableSource(this.table, this.isStreamingMode, this.predicate, this.projectFields, this.limit, this.splitBatchSize, this.splitAssignMode);
    }

    @Override
    public String asSummaryString() {
        return "Paimon-SystemTable-Source";
    }

    @Override
    public void pushWatermark(WatermarkStrategy<RowData> watermarkStrategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TableStats reportStatistics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listAcceptedFilterFields() {
        return Collections.emptyList();
    }

    @Override
    public void applyDynamicFiltering(List<String> candidateFilterFields) {
        throw new UnsupportedOperationException(String.format("Cannot apply dynamic filtering to Paimon system table '%s'.", this.table.name()));
    }

    @Override
    public boolean isStreaming() {
        return this.isStreamingMode;
    }
}

