/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.utils.StringUtils;

public class RetryingMetaStoreClientFactory {
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS = ImmutableMap.builder().put(new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName)).put(new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).put(new Class[]{Configuration.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).build();
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS_SHADED = ImmutableMap.builder().put(new Class[]{HiveConf.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf)).put(new Class[]{HiveConf.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).put(new Class[]{Configuration.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).build();

    public IMetaStoreClient createClient(HiveConf hiveConf, String clientClassName) {
        IMetaStoreClient client;
        Method getProxy = null;
        HiveMetastoreProxySupplier supplier = null;
        RuntimeException methodNotFound = new RuntimeException("Failed to find desired getProxy method from RetryingMetaStoreClient");
        LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier> suppliers = new LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier>(PROXY_SUPPLIERS);
        if (HiveMetaStoreClient.class.getName().equals(clientClassName)) {
            suppliers.putAll(PROXY_SUPPLIERS_SHADED);
        }
        for (Map.Entry entry : suppliers.entrySet()) {
            Class[] classes = (Class[])entry.getKey();
            try {
                getProxy = RetryingMetaStoreClient.class.getMethod("getProxy", classes);
                supplier = (HiveMetastoreProxySupplier)entry.getValue();
            }
            catch (NoSuchMethodException e) {
                methodNotFound.addSuppressed(e);
            }
        }
        if (getProxy == null) {
            throw methodNotFound;
        }
        try {
            client = supplier.get(getProxy, (Configuration)hiveConf, clientClassName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return StringUtils.isNullOrWhitespaceOnly(hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)) ? client : HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)client);
    }

    public static interface HiveMetastoreProxySupplier {
        public IMetaStoreClient get(Method var1, Configuration var2, String var3) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

