/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.io.SeekableDataInputView;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MathUtils;

public class FileBasedRandomInputView
extends AbstractPagedInputView
implements SeekableDataInputView,
Closeable {
    private final RandomAccessFile file;
    private final long fileLength;
    private final CacheManager cacheManager;
    private final Map<Integer, SegmentContainer> segments;
    private final int segmentSize;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private int currentSegmentIndex;

    public FileBasedRandomInputView(File file, CacheManager cacheManager, int segmentSize) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, "r");
        this.fileLength = file.length();
        this.cacheManager = cacheManager;
        this.segments = new HashMap<Integer, SegmentContainer>();
        this.segmentSize = segmentSize;
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.segmentSizeMask = segmentSize - 1;
        this.currentSegmentIndex = -1;
    }

    @Override
    public void setReadPosition(long position) {
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = this.positionToSegmentIndex(position);
        MemorySegment segment = this.getCurrentPage();
        this.seekInput(segment, offset, this.getLimitForSegment(segment));
    }

    private MemorySegment getCurrentPage() {
        SegmentContainer container = this.segments.get(this.currentSegmentIndex);
        if (container == null || container.accessCount == 10) {
            long offset = this.segmentIndexToPosition(this.currentSegmentIndex);
            int length = (int)Math.min((long)this.segmentSize, this.fileLength - offset);
            container = new SegmentContainer(this.cacheManager.getPage(this.file, offset, length, this::invalidPage));
            this.segments.put(this.currentSegmentIndex, container);
        }
        return container.access();
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
        ++this.currentSegmentIndex;
        if (this.segmentIndexToPosition(this.currentSegmentIndex) >= this.fileLength) {
            throw new EOFException();
        }
        return this.getCurrentPage();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return segment.size();
    }

    private void invalidPage(long position, int length) {
        this.segments.remove(this.positionToSegmentIndex(position));
    }

    @Override
    public void close() throws IOException {
        ArrayList<Integer> pages = new ArrayList<Integer>(this.segments.keySet());
        pages.forEach(page -> {
            long offset = this.segmentIndexToPosition((int)page);
            int length = (int)Math.min((long)this.segmentSize, this.fileLength - offset);
            this.cacheManager.invalidPage(this.file, offset, length);
        });
        this.file.close();
    }

    private int positionToSegmentIndex(long position) {
        return (int)(position >>> this.segmentSizeBits);
    }

    private long segmentIndexToPosition(int segmentIndex) {
        return (long)segmentIndex << this.segmentSizeBits;
    }

    public RandomAccessFile file() {
        return this.file;
    }

    private static class SegmentContainer {
        private final MemorySegment segment;
        private int accessCount;

        private SegmentContainer(MemorySegment segment) {
            this.segment = segment;
            this.accessCount = 0;
        }

        private MemorySegment access() {
            ++this.accessCount;
            return this.segment;
        }
    }
}

