/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.EnvOptions;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileWriter;

public class BulkLoader {
    private final String uuid = UUID.randomUUID().toString();
    private final ColumnFamilyHandle columnFamily;
    private final String path;
    private final RocksDB db;
    private final Options options;
    private final List<String> files = new ArrayList<String>();
    private SstFileWriter writer = null;
    private int sstIndex = 0;
    private long recordNum = 0L;

    public BulkLoader(RocksDB db, Options options, ColumnFamilyHandle columnFamily, String path) {
        this.db = db;
        this.options = options;
        this.columnFamily = columnFamily;
        this.path = path;
    }

    public void write(byte[] key, byte[] value) throws WriteException {
        try {
            if (this.writer == null) {
                this.writer = new SstFileWriter(new EnvOptions(), this.options);
                String path = new File(this.path, "sst-" + this.uuid + "-" + this.sstIndex++).getPath();
                this.writer.open(path);
                this.files.add(path);
            }
            try {
                this.writer.put(key, value);
            }
            catch (RocksDBException e) {
                throw new WriteException(e);
            }
            ++this.recordNum;
            if (this.recordNum % 1000L == 0L && this.writer.fileSize() >= this.options.targetFileSizeBase()) {
                this.writer.finish();
                this.writer = null;
                this.recordNum = 0L;
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.finish();
            }
            if (this.files.size() > 0) {
                IngestExternalFileOptions ingestOptions = new IngestExternalFileOptions();
                this.db.ingestExternalFile(this.columnFamily, this.files, ingestOptions);
                ingestOptions.close();
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    public static class WriteException
    extends Exception {
        public WriteException(Throwable cause) {
            super(cause);
        }
    }
}

