/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class ManifestEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int totalBuckets;
    private final DataFileMeta file;

    public ManifestEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, DataFileMeta file) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.file = file;
    }

    public FileKind kind() {
        return this.kind;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public int totalBuckets() {
        return this.totalBuckets;
    }

    public DataFileMeta file() {
        return this.file;
    }

    public Identifier identifier() {
        return new Identifier(this.partition, this.bucket, this.file.level(), this.file.fileName());
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_KIND", new TinyIntType(false)));
        fields.add(new DataField(1, "_PARTITION", SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_BUCKET", new IntType(false)));
        fields.add(new DataField(3, "_TOTAL_BUCKETS", new IntType(false)));
        fields.add(new DataField(4, "_FILE", DataFileMeta.schema()));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestEntry)) {
            return false;
        }
        ManifestEntry that = (ManifestEntry)o;
        return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.totalBuckets == that.totalBuckets && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public String toString() {
        return String.format("{%s, %s, %d, %d, %s}", new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public static Collection<ManifestEntry> mergeEntries(Iterable<ManifestEntry> entries) {
        LinkedHashMap<Identifier, ManifestEntry> map = new LinkedHashMap<Identifier, ManifestEntry>();
        ManifestEntry.mergeEntries(entries, map);
        return map.values();
    }

    public static void mergeEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, Map<Identifier, ManifestEntry> map) {
        List manifestReadFutures = manifestFiles.stream().map(manifestFileMeta -> CompletableFuture.supplyAsync(() -> manifestFile.read(manifestFileMeta.fileName()), FileUtils.COMMON_IO_FORK_JOIN_POOL)).collect(Collectors.toList());
        try {
            for (CompletableFuture taskResult : manifestReadFutures) {
                ManifestEntry.mergeEntries((Iterable)taskResult.get(), map);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to read manifest file.", e);
        }
    }

    public static void mergeEntries(Iterable<ManifestEntry> entries, Map<Identifier, ManifestEntry> map) {
        block4: for (ManifestEntry entry : entries) {
            Identifier identifier = entry.identifier();
            switch (entry.kind()) {
                case ADD: {
                    Preconditions.checkState(!map.containsKey(identifier), "Trying to add file %s which is already added. Manifest might be corrupted.", identifier);
                    map.put(identifier, entry);
                    continue block4;
                }
                case DELETE: {
                    if (map.containsKey(identifier)) {
                        map.remove(identifier);
                        continue block4;
                    }
                    map.put(identifier, entry);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
    }

    public static void assertNoDelete(Collection<ManifestEntry> entries) {
        for (ManifestEntry entry : entries) {
            Preconditions.checkState(entry.kind() != FileKind.DELETE, "Trying to delete file %s which is not previously added. Manifest might be corrupted.", entry.file().fileName());
        }
    }

    public static class Identifier {
        public final BinaryRow partition;
        public final int bucket;
        public final int level;
        public final String fileName;
        private Integer hash;

        private Identifier(BinaryRow partition, int bucket, int level, String fileName) {
            this.partition = partition;
            this.bucket = bucket;
            this.level = level;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.level == that.level && Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = Objects.hash(this.partition, this.bucket, this.level, this.fileName);
            }
            return this.hash;
        }

        public String toString() {
            return String.format("{%s, %d, %d, %s}", this.partition, this.bucket, this.level, this.fileName);
        }

        public String toString(FileStorePathFactory pathFactory) {
            return pathFactory.getPartitionString(this.partition) + ", bucket " + this.bucket + ", level " + this.level + ", file " + this.fileName;
        }
    }
}

