/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeTreeCompactRewriter;
import org.apache.paimon.reader.RecordReaderIterator;

public abstract class ChangelogMergeTreeRewriter
extends MergeTreeCompactRewriter {
    protected final int maxLevel;
    protected final CoreOptions.MergeEngine mergeEngine;
    protected final RecordEqualiser valueEqualiser;
    protected final boolean changelogRowDeduplicate;

    public ChangelogMergeTreeRewriter(int maxLevel, CoreOptions.MergeEngine mergeEngine, KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate) {
        super(readerFactory, writerFactory, keyComparator, mfFactory, mergeSorter);
        this.maxLevel = maxLevel;
        this.mergeEngine = mergeEngine;
        this.valueEqualiser = valueEqualiser;
        this.changelogRowDeduplicate = changelogRowDeduplicate;
    }

    protected abstract boolean rewriteChangelog(int var1, boolean var2, List<List<SortedRun>> var3);

    protected abstract UpgradeStrategy upgradeChangelog(int var1, DataFileMeta var2);

    protected abstract MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int var1);

    protected boolean rewriteLookupChangelog(int outputLevel, List<List<SortedRun>> sections) {
        if (outputLevel == 0) {
            return false;
        }
        for (List<SortedRun> runs : sections) {
            for (SortedRun run : runs) {
                for (DataFileMeta file : run.files()) {
                    if (file.level() != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        if (this.rewriteChangelog(outputLevel, dropDelete, sections)) {
            return this.rewriteChangelogCompaction(outputLevel, sections, true);
        }
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompactResult rewriteChangelogCompaction(int outputLevel, List<List<SortedRun>> sections, boolean rewriteCompactFile) throws Exception {
        ArrayList sectionReaders = new ArrayList();
        for (List<SortedRun> section : sections) {
            sectionReaders.add(() -> MergeTreeReaders.readerForSection(section, this.readerFactory, this.keyComparator, this.createMergeWrapper(outputLevel), this.mergeSorter));
        }
        RecordReaderIterator iterator = null;
        RollingFileWriter<KeyValue, DataFileMeta> compactFileWriter = null;
        RollingFileWriter<KeyValue, DataFileMeta> changelogFileWriter = null;
        try {
            iterator = new RecordReaderIterator(ConcatRecordReader.create(sectionReaders));
            if (rewriteCompactFile) {
                compactFileWriter = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
            }
            changelogFileWriter = this.writerFactory.createRollingChangelogFileWriter(outputLevel);
            while (iterator.hasNext()) {
                ChangelogResult result = (ChangelogResult)iterator.next();
                if (rewriteCompactFile && result.result() != null) {
                    compactFileWriter.write(result.result());
                }
                for (KeyValue kv : result.changelogs()) {
                    changelogFileWriter.write(kv);
                }
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
            if (compactFileWriter != null) {
                compactFileWriter.close();
            }
            if (changelogFileWriter != null) {
                changelogFileWriter.close();
            }
        }
        List<DataFileMeta> before = ChangelogMergeTreeRewriter.extractFilesFromSections(sections);
        List<DataFileMeta> after = rewriteCompactFile ? compactFileWriter.result() : before.stream().map(x -> x.upgrade(outputLevel)).collect(Collectors.toList());
        return new CompactResult(before, after, (List<DataFileMeta>)changelogFileWriter.result());
    }

    @Override
    public CompactResult upgrade(int outputLevel, DataFileMeta file) throws Exception {
        UpgradeStrategy strategy = this.upgradeChangelog(outputLevel, file);
        if (strategy.changelog) {
            return this.rewriteChangelogCompaction(outputLevel, Collections.singletonList(Collections.singletonList(SortedRun.fromSingle(file))), strategy.rewrite);
        }
        return super.upgrade(outputLevel, file);
    }

    protected static enum UpgradeStrategy {
        NO_CHANGELOG(false, false),
        CHANGELOG_NO_REWRITE(true, false),
        CHANGELOG_WITH_REWRITE(true, true);

        private final boolean changelog;
        private final boolean rewrite;

        private UpgradeStrategy(boolean changelog, boolean rewrite) {
            this.changelog = changelog;
            this.rewrite = rewrite;
        }
    }
}

