/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.RowType;

public class FieldNestedUpdateAgg
extends FieldAggregator {
    public static final String NAME = "nested_update";
    private final int nestedFields;
    @Nullable
    private final Projection keyProjection;

    public FieldNestedUpdateAgg(ArrayType dataType, List<String> nestedKey) {
        super(dataType);
        RowType nestedType = (RowType)dataType.getElementType();
        this.nestedFields = nestedType.getFieldCount();
        this.keyProjection = nestedKey.isEmpty() ? null : CodeGenUtils.newProjection(nestedType, nestedKey);
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        int i;
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        InternalArray acc2 = (InternalArray)accumulator;
        InternalArray input = (InternalArray)inputField;
        ArrayList<InternalRow> rows = new ArrayList<InternalRow>();
        for (i = 0; i < acc2.size(); ++i) {
            rows.add(acc2.getRow(i, this.nestedFields));
        }
        for (i = 0; i < input.size(); ++i) {
            rows.add(input.getRow(i, this.nestedFields));
        }
        if (this.keyProjection != null) {
            HashMap<BinaryRow, InternalRow> map = new HashMap<BinaryRow, InternalRow>();
            for (InternalRow row : rows) {
                BinaryRow key = this.keyProjection.apply(row).copy();
                map.put(key, row);
            }
            rows = new ArrayList(map.values());
        }
        return new GenericArray(rows.toArray());
    }
}

