/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.operation.metrics.ScanMetrics;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.utils.Filter;

public interface FileStoreScan {
    public FileStoreScan withPartitionFilter(Predicate var1);

    public FileStoreScan withPartitionFilter(List<BinaryRow> var1);

    public FileStoreScan withBucket(int var1);

    public FileStoreScan withBucketFilter(Filter<Integer> var1);

    public FileStoreScan withPartitionBucket(BinaryRow var1, int var2);

    public FileStoreScan withSnapshot(long var1);

    public FileStoreScan withSnapshot(Snapshot var1);

    public FileStoreScan withManifestList(List<ManifestFileMeta> var1);

    public FileStoreScan withKind(ScanMode var1);

    public FileStoreScan withLevelFilter(Filter<Integer> var1);

    public FileStoreScan withDataFileTimeMills(long var1);

    public FileStoreScan withManifestCacheFilter(ManifestCacheFilter var1);

    public FileStoreScan withMetrics(ScanMetrics var1);

    public Plan plan();

    public static interface Plan {
        @Nullable
        public Long watermark();

        @Nullable
        public Long snapshotId();

        public ScanMode scanMode();

        public List<ManifestEntry> files();

        default public List<ManifestEntry> files(FileKind kind) {
            return this.files().stream().filter(e -> e.kind() == kind).collect(Collectors.toList());
        }

        public static Map<BinaryRow, Map<Integer, List<DataFileMeta>>> groupByPartFiles(List<ManifestEntry> files) {
            LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>> groupBy = new LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>>();
            for (ManifestEntry entry : files) {
                groupBy.computeIfAbsent(entry.partition(), k -> new LinkedHashMap()).computeIfAbsent(entry.bucket(), k -> new ArrayList()).add(entry.file());
            }
            return groupBy;
        }
    }
}

