/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.partition.PartitionTimeExtractor;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public class PartitionExpire {
    private final List<String> partitionKeys;
    private final RowDataToObjectArrayConverter toObjectArrayConverter;
    private final Duration expirationTime;
    private final Duration checkInterval;
    private final PartitionTimeExtractor timeExtractor;
    private final FileStoreScan scan;
    private final FileStoreCommit commit;
    private LocalDateTime lastCheck;

    public PartitionExpire(RowType partitionType, Duration expirationTime, Duration checkInterval, String timePattern, String timeFormatter, FileStoreScan scan, FileStoreCommit commit) {
        this.partitionKeys = partitionType.getFieldNames();
        this.toObjectArrayConverter = new RowDataToObjectArrayConverter(partitionType);
        this.expirationTime = expirationTime;
        this.checkInterval = checkInterval;
        this.timeExtractor = new PartitionTimeExtractor(timePattern, timeFormatter);
        this.scan = scan;
        this.commit = commit;
        this.lastCheck = LocalDateTime.now();
    }

    public PartitionExpire withLock(Lock lock) {
        this.commit.withLock(lock);
        return this;
    }

    public void expire(long commitIdentifier) {
        this.expire(LocalDateTime.now(), commitIdentifier);
    }

    @VisibleForTesting
    void setLastCheck(LocalDateTime time) {
        this.lastCheck = time;
    }

    @VisibleForTesting
    void expire(LocalDateTime now, long commitIdentifier) {
        if (now.isAfter(this.lastCheck.plus(this.checkInterval))) {
            this.doExpire(now.minus(this.expirationTime), commitIdentifier);
            this.lastCheck = now;
        }
    }

    private void doExpire(LocalDateTime expireDateTime, long commitIdentifier) {
        List<BinaryRow> partitions = this.readPartitions();
        ArrayList<Map<String, String>> expired = new ArrayList<Map<String, String>>();
        for (BinaryRow partition : partitions) {
            Object[] array = this.toObjectArrayConverter.convert(partition);
            LocalDateTime partTime = this.timeExtractor.extract(this.partitionKeys, Arrays.asList(array));
            if (partTime == null || !expireDateTime.isAfter(partTime)) continue;
            expired.add(this.toPartitionString(array));
        }
        if (expired.size() > 0) {
            this.commit.dropPartitions(expired, commitIdentifier);
        }
    }

    private Map<String, String> toPartitionString(Object[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionKeys.size(); ++i) {
            map.put(this.partitionKeys.get(i), array[i].toString());
        }
        return map;
    }

    private List<BinaryRow> readPartitions() {
        return this.scan.plan().files().stream().map(ManifestEntry::partition).distinct().collect(Collectors.toList());
    }
}

