/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class FieldStatsConverters {
    private final Function<Long, List<DataField>> schemaFields;
    private final long tableSchemaId;
    private final List<DataField> tableDataFields;
    private final ConcurrentMap<Long, FieldStatsArraySerializer> serializers;
    private final AtomicReference<List<DataField>> tableFields;

    public FieldStatsConverters(Function<Long, List<DataField>> schemaFields, long tableSchemaId) {
        this.schemaFields = schemaFields;
        this.tableSchemaId = tableSchemaId;
        this.tableDataFields = schemaFields.apply(tableSchemaId);
        this.serializers = new ConcurrentHashMap<Long, FieldStatsArraySerializer>();
        this.tableFields = new AtomicReference();
    }

    public FieldStatsArraySerializer getOrCreate(long dataSchemaId) {
        return this.serializers.computeIfAbsent(dataSchemaId, id -> {
            if (this.tableSchemaId == id) {
                return new FieldStatsArraySerializer(new RowType(this.schemaFields.apply((Long)id)));
            }
            List<DataField> schemaTableFields = this.tableFields.updateAndGet(v -> v == null ? this.tableDataFields : v);
            List<DataField> dataFields = this.schemaFields.apply((Long)id);
            int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(schemaTableFields, dataFields);
            CastExecutor<?, ?>[] castExecutors = SchemaEvolutionUtil.createConvertMapping(schemaTableFields, dataFields, indexMapping);
            return new FieldStatsArraySerializer(new RowType(dataFields), indexMapping, castExecutors);
        });
    }

    public List<DataField> tableDataFields() {
        return this.tableDataFields;
    }
}

