/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.utils.Preconditions;

public class DynamicBucketRowKeyExtractor
extends RowKeyExtractor {
    public DynamicBucketRowKeyExtractor(TableSchema schema) {
        super(schema);
        int numBuckets = new CoreOptions(schema.options()).bucket();
        Preconditions.checkArgument(numBuckets == -1, "Only 'bucket' = '-1' is allowed for 'DynamicBucketRowKeyExtractor', but found: " + numBuckets);
    }

    @Override
    public int bucket() {
        throw new IllegalArgumentException("Can't extract bucket from row in dynamic bucket mode.");
    }
}

